/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.composer;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobErrorHandler;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.ImmutableFormReleaseDocument;
import io.dialob.client.api.ImmutableStoreEntity;
import io.dialob.client.spi.DialobTypesMapperImpl;
import io.dialob.client.spi.migration.MigrationSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.core.io.Resource;

public class ReleaseDumpToStoreEntityVisitor {
    private final DialobTypesMapperImpl mapper;
    private final MigrationSupport.MigrationContent release;
    private final List<String> skipOnForms = new ArrayList<String>();

    public ReleaseDumpToStoreEntityVisitor(Resource text, ObjectMapper om) {
        this.mapper = new DialobTypesMapperImpl(om);
        this.release = this.readDumpRelease(text);
    }

    private MigrationSupport.MigrationContent readDumpRelease(Resource text) {
        try {
            MigrationSupport reader = new MigrationSupport(this.mapper);
            return reader.read(text.getInputStream());
        }
        catch (Exception e) {
            throw new ReleaseDumpToStoreEntityException("Failed to load asset from: " + text.getFilename() + "!" + e.getMessage(), e);
        }
    }

    public void visit(Consumer<DialobStore.StoreEntity> consumer) {
        this.release.getRelease().getValues().stream().filter(e -> e.getBodyType() == DialobDocument.DocumentType.FORM_REV).map(this::visitBody).flatMap(e -> e.stream()).forEach(consumer);
        this.release.getRelease().getValues().stream().filter(e -> e.getBodyType() == DialobDocument.DocumentType.FORM).map(this::visitBody).flatMap(e -> e.stream()).forEach(consumer);
        this.initRelease().forEach(consumer);
    }

    private List<DialobStore.StoreEntity> visitBody(DialobDocument.FormReleaseValueDocument original) {
        switch (original.getBodyType()) {
            case FORM: {
                return this.initForm(original);
            }
            case FORM_REV: {
                return this.initFormRev(original);
            }
            case RELEASE: {
                return Collections.emptyList();
            }
        }
        throw new ReleaseDumpToStoreEntityException("Unknown asset: '" + original.getBodyType() + "'!");
    }

    public List<DialobStore.StoreEntity> initForm(DialobDocument.FormReleaseValueDocument original) {
        DialobDocument.FormDocument newFormDocument = this.mapper.readFormDoc(original.getCommands());
        if (this.skipOnForms.contains(newFormDocument.getId())) {
            return Collections.emptyList();
        }
        String body = this.mapper.toStoreBody(newFormDocument);
        return Arrays.asList(ImmutableStoreEntity.builder().body(body).bodyType(original.getBodyType()).id(newFormDocument.getId()).version(newFormDocument.getVersion()).build());
    }

    public List<DialobStore.StoreEntity> initFormRev(DialobDocument.FormReleaseValueDocument original) {
        DialobDocument.FormRevisionDocument newRevDocument = this.mapper.readFormRevDoc(original.getCommands());
        String body = this.mapper.toStoreBody(newRevDocument);
        return Arrays.asList(ImmutableStoreEntity.builder().body(body).bodyType(original.getBodyType()).id(newRevDocument.getId()).version(newRevDocument.getVersion() == null ? "undefined" : newRevDocument.getVersion()).build());
    }

    private List<DialobStore.StoreEntity> initRelease() {
        DialobDocument.FormReleaseDocument original = this.release.getRelease();
        ImmutableFormReleaseDocument next = ImmutableFormReleaseDocument.builder().from(original).description("imported from a release").build();
        String body = this.mapper.toStoreBody(next);
        return Arrays.asList(ImmutableStoreEntity.builder().id(original.getName()).version("").body(body).bodyType(original.getType()).build());
    }

    public static class ReleaseDumpToStoreEntityException
    extends RuntimeException
    implements DialobErrorHandler.DialobClientException {
        private static final long serialVersionUID = 7193990799948041231L;

        public ReleaseDumpToStoreEntityException(String message) {
            super(message);
        }

        public ReleaseDumpToStoreEntityException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

