/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.composer;

import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobComposer;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobErrorHandler;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.ImmutableCreateStoreEntity;
import io.dialob.client.api.ImmutableEmptyCommand;
import io.dialob.client.api.ImmutableFormReleaseDocument;
import io.dialob.client.api.ImmutableUpdateStoreEntity;
import io.dialob.client.spi.exceptions.ErrorMsgBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ImportReleaseVisitor {
    private final DialobClient client;
    private final DialobDocument.FormReleaseDocument asset;
    private final DialobComposer.ComposerState state;
    private final List<String> skipOnForms = new ArrayList<String>();

    public ImportReleaseVisitor(DialobComposer.ComposerState state, DialobDocument.FormReleaseDocument asset, DialobClient client) {
        this.asset = asset;
        this.state = state;
        this.client = client;
    }

    public List<DialobStore.StoreCommand> visit() {
        List revisions = this.asset.getValues().stream().filter(e -> e.getBodyType() == DialobDocument.DocumentType.FORM_REV).map(this::visitBody).flatMap(e -> e.stream()).collect(Collectors.toList());
        List forms = this.asset.getValues().stream().filter(e -> e.getBodyType() == DialobDocument.DocumentType.FORM).map(this::visitBody).flatMap(e -> e.stream()).collect(Collectors.toList());
        ArrayList<DialobStore.StoreCommand> result = new ArrayList<DialobStore.StoreCommand>(this.initRelease(this.asset));
        result.addAll(revisions);
        result.addAll(forms);
        return Collections.unmodifiableList(result);
    }

    private List<DialobStore.StoreCommand> visitBody(DialobDocument.FormReleaseValueDocument original) {
        switch (original.getBodyType()) {
            case FORM: {
                return this.initForm(original);
            }
            case FORM_REV: {
                return this.initFormRev(original);
            }
            case RELEASE: {
                return Collections.emptyList();
            }
        }
        throw new ImportReleaseDocumentException("Unknown asset: '" + original.getBodyType() + "'!");
    }

    public List<DialobStore.StoreCommand> initForm(DialobDocument.FormReleaseValueDocument original) {
        DialobDocument.FormDocument newFormDocument = this.client.getConfig().getMapper().readFormDoc(original.getCommands());
        if (this.skipOnForms.contains(newFormDocument.getId())) {
            return Arrays.asList(ImmutableEmptyCommand.builder().bodyType(original.getBodyType()).id(newFormDocument.getId()).description(new ErrorMsgBuilder("Form document can't be updated because revision conflict").field("id", newFormDocument.getId()).build()).build());
        }
        DialobDocument.FormDocument oldDocument = this.state.getForms().get(newFormDocument.getId());
        if (oldDocument == null) {
            String body = this.client.getConfig().getMapper().toStoreBody(newFormDocument);
            return Arrays.asList(ImmutableCreateStoreEntity.builder().body(body).bodyType(original.getBodyType()).id(newFormDocument.getId()).version(newFormDocument.getVersion()).build());
        }
        if (!oldDocument.getVersion().equals(newFormDocument.getVersion())) {
            return Arrays.asList(ImmutableEmptyCommand.builder().bodyType(original.getBodyType()).id(newFormDocument.getId()).description(new ErrorMsgBuilder("Form document already exists, update not possible because of version conflict").field("id", newFormDocument.getId()).field("existing version", oldDocument.getVersion()).field("new version", newFormDocument.getVersion()).build()).build());
        }
        String body = this.client.getConfig().getMapper().toStoreBody(newFormDocument);
        return Arrays.asList(ImmutableUpdateStoreEntity.builder().body(body).bodyType(original.getBodyType()).id(newFormDocument.getId()).version(newFormDocument.getVersion()).build());
    }

    public List<DialobStore.StoreCommand> initFormRev(DialobDocument.FormReleaseValueDocument original) {
        DialobDocument.FormRevisionDocument newRevDocument = this.client.getConfig().getMapper().readFormRevDoc(original.getCommands());
        DialobDocument.FormDocument oldDocument = this.state.getForms().get(newRevDocument.getId());
        if (oldDocument == null) {
            String body = this.client.getConfig().getMapper().toStoreBody(newRevDocument);
            return Arrays.asList(ImmutableCreateStoreEntity.builder().body(body).bodyType(original.getBodyType()).id(newRevDocument.getId()).version(newRevDocument.getVersion()).build());
        }
        if (!oldDocument.getVersion().equals(newRevDocument.getVersion())) {
            this.skipOnForms.add(newRevDocument.getHead());
            newRevDocument.getEntries().forEach(e -> this.skipOnForms.add(e.getFormId()));
            return Arrays.asList(ImmutableEmptyCommand.builder().bodyType(original.getBodyType()).id(newRevDocument.getId()).description(new ErrorMsgBuilder("Revision document already exists, update not possible because of version conflict").field("id", newRevDocument.getId()).field("existing version", oldDocument.getVersion()).field("new version", newRevDocument.getVersion()).build()).build());
        }
        String body = this.client.getConfig().getMapper().toStoreBody(newRevDocument);
        return Arrays.asList(ImmutableUpdateStoreEntity.builder().body(body).bodyType(original.getBodyType()).id(newRevDocument.getId()).version(newRevDocument.getVersion()).build());
    }

    private List<DialobStore.StoreCommand> initRelease(DialobDocument.FormReleaseDocument original) {
        ImmutableFormReleaseDocument next = ImmutableFormReleaseDocument.builder().from(original).description("imported from a release").build();
        String body = this.client.getConfig().getMapper().toStoreBody(next);
        return Arrays.asList(ImmutableCreateStoreEntity.builder().body(body).bodyType(original.getType()).build());
    }

    public static class ImportReleaseDocumentException
    extends RuntimeException
    implements DialobErrorHandler.DialobClientException {
        private static final long serialVersionUID = 7193990799948041231L;

        public ImportReleaseDocumentException(String message) {
            super(message);
        }
    }
}

