/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.composer;

import io.dialob.client.api.DialobComposer;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobErrorHandler;
import io.dialob.client.api.ImmutableComposerDocumentState;
import io.dialob.client.spi.exceptions.ErrorMsgBuilder;

public class GetComposerDocumentState {
    private final DialobComposer.ComposerState state;
    private final String idOrName;
    private final String version;

    public GetComposerDocumentState(DialobComposer.ComposerState state, String idOrName, String version) {
        this.state = state;
        this.idOrName = idOrName;
        this.version = "LATEST".equals(version) ? null : version;
    }

    public DialobComposer.ComposerDocumentState get() {
        for (DialobDocument.FormRevisionDocument rev : this.state.getRevs().values()) {
            DialobDocument.FormRevisionDocument foundFromRev = this.findFromRev(rev);
            if (foundFromRev != null) {
                return this.buildFromRev(rev);
            }
            DialobDocument.FormRevisionEntryDocument foundFromDoc = this.findFromDocument(rev);
            if (foundFromDoc == null) continue;
            DialobDocument.FormDocument form = this.state.getForms().get(foundFromDoc.getFormId());
            return ImmutableComposerDocumentState.builder().revision(rev).form(form).build();
        }
        throw this.notFound();
    }

    private DialobComposer.ComposerDocumentState buildFromRev(DialobDocument.FormRevisionDocument rev) {
        if (this.version == null) {
            DialobDocument.FormDocument form = this.state.getForms().get(rev.getHead());
            return ImmutableComposerDocumentState.builder().revision(rev).form(form).build();
        }
        for (DialobDocument.FormRevisionEntryDocument entry : rev.getEntries()) {
            if (entry.getId().equals(this.version)) {
                DialobDocument.FormDocument form = this.state.getForms().get(entry.getFormId());
                return ImmutableComposerDocumentState.builder().revision(rev).form(form).build();
            }
            if (entry.getFormId().equals(this.version)) {
                DialobDocument.FormDocument form = this.state.getForms().get(entry.getFormId());
                return ImmutableComposerDocumentState.builder().revision(rev).form(form).build();
            }
            if (!entry.getRevisionName().equals(this.version)) continue;
            DialobDocument.FormDocument form = this.state.getForms().get(entry.getFormId());
            return ImmutableComposerDocumentState.builder().revision(rev).form(form).build();
        }
        throw this.notFound();
    }

    private DialobDocument.FormRevisionEntryDocument findFromDocument(DialobDocument.FormRevisionDocument rev) {
        for (DialobDocument.FormRevisionEntryDocument entry : rev.getEntries()) {
            if (entry.getId().equals(this.idOrName)) {
                return entry;
            }
            if (!entry.getFormId().equals(this.idOrName)) continue;
            return entry;
        }
        return null;
    }

    private DialobDocument.FormRevisionDocument findFromRev(DialobDocument.FormRevisionDocument rev) {
        if (rev.getId().equals(this.idOrName)) {
            return rev;
        }
        if (rev.getName().equals(this.idOrName)) {
            return rev;
        }
        return null;
    }

    private DialobErrorHandler.DocumentNotFoundException notFound() {
        return new DialobErrorHandler.DocumentNotFoundException(new ErrorMsgBuilder("Document not found!").field("id/formName", this.idOrName).field("version/tag", this.version).build());
    }
}

