/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.composer;

import io.dialob.client.api.DialobComposer;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobErrorHandler;
import io.dialob.client.api.DialobStore;
import java.util.Collections;
import java.util.List;

public class DeleteEntityVisitor {
    private final String assetId;
    private final DialobComposer.ComposerState state;

    public DeleteEntityVisitor(DialobComposer.ComposerState state, String assetId, String assetVersion) {
        this.assetId = assetId;
        this.state = state;
    }

    public List<DialobStore.StoreCommand> visit() {
        DialobDocument asset = this.visitId();
        DialobDocument.DocumentType bodyType = asset.getType();
        switch (bodyType) {
            case FORM: {
                return this.visitForm((DialobDocument.FormDocument)asset);
            }
            case FORM_REV: {
                return this.visitFormRev((DialobDocument.FormRevisionDocument)asset);
            }
            case RELEASE: {
                return this.visitRelease((DialobDocument.FormReleaseDocument)asset);
            }
        }
        throw new DeleteDocumentException("Unknown asset of type: '" + bodyType + "'!");
    }

    private DialobDocument visitId() {
        if (this.state.getForms().containsKey(this.assetId)) {
            return this.state.getForms().get(this.assetId);
        }
        if (this.state.getRevs().containsKey(this.assetId)) {
            return this.state.getRevs().get(this.assetId);
        }
        if (this.state.getReleases().containsKey(this.assetId)) {
            return this.state.getReleases().get(this.assetId);
        }
        throw new DialobErrorHandler.DocumentNotFoundException("No entity with id: '" + this.assetId + "'");
    }

    private List<DialobStore.StoreCommand> visitFormRev(DialobDocument.FormRevisionDocument form) {
        return Collections.emptyList();
    }

    private List<DialobStore.StoreCommand> visitForm(DialobDocument.FormDocument flowTask) {
        return Collections.emptyList();
    }

    private List<DialobStore.StoreCommand> visitRelease(DialobDocument.FormReleaseDocument decision) {
        return Collections.emptyList();
    }

    public static class DeleteDocumentException
    extends RuntimeException
    implements DialobErrorHandler.DialobClientException {
        private static final long serialVersionUID = 7193990799948041231L;

        public DeleteDocumentException(String message) {
            super(message);
        }
    }
}

