/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.composer;

import io.dialob.client.api.DialobClientConfig;
import io.dialob.client.api.DialobComposer;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.ImmutableComposerReleaseState;
import io.dialob.client.api.ImmutableCreateStoreEntity;
import io.dialob.client.api.ImmutableFormReleaseDocument;
import io.dialob.client.api.ImmutableFormReleaseValueDocument;
import io.dialob.client.spi.migration.MigrationSupport;
import io.dialob.client.spi.support.Sha2;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;

public class CreateReleaseVisitor {
    private final DialobClientConfig config;
    private final DialobComposer.ComposerState state;
    private final StringBuilder log = new StringBuilder();

    public Result visit(DialobComposer.CreateComposerRelease command) {
        String commands;
        ArrayList<ImmutableFormReleaseValueDocument> values = new ArrayList<ImmutableFormReleaseValueDocument>();
        for (DialobDocument.FormDocument document : this.state.getForms().values()) {
            this.visitLog(document);
            commands = this.config.getMapper().toJson(document);
            values.add(ImmutableFormReleaseValueDocument.builder().bodyType(DialobDocument.DocumentType.FORM).commands(commands).hash(Sha2.blob(commands)).build());
        }
        for (DialobDocument.FormRevisionDocument revision : this.state.getRevs().values()) {
            this.visitLog(revision);
            commands = this.config.getMapper().toJson(revision);
            values.add(ImmutableFormReleaseValueDocument.builder().bodyType(DialobDocument.DocumentType.FORM_REV).commands(commands).hash(Sha2.blob(commands)).build());
        }
        ImmutableFormReleaseDocument rel = ImmutableFormReleaseDocument.builder().name(command.getName()).description(command.getDescription()).created(LocalDateTime.now()).addAllValues(values).build();
        MigrationSupport.Migration compress = MigrationSupport.Migration.builder().log(this.log.toString()).release(rel).build();
        String mig = this.visitMigration(compress);
        ImmutableCreateStoreEntity storeEntity = ImmutableCreateStoreEntity.builder().bodyType(DialobDocument.DocumentType.RELEASE).body(this.config.getMapper().toStoreBody(rel)).build();
        ImmutableComposerReleaseState releaseState = ImmutableComposerReleaseState.builder().description(command.getDescription()).name(command.getName()).content(mig).hash(compress.getHash()).id("").build();
        return Result.builder().storeEntity(storeEntity).releaseState(releaseState).build();
    }

    private void visitLog(DialobDocument.FormDocument rev) {
    }

    private void visitLog(DialobDocument.FormRevisionDocument rev) {
        this.log.append(System.lineSeparator()).append("  - form id: ").append(rev.getId()).append(System.lineSeparator()).append("  - form name: '").append(rev.getName()).append("'").append(System.lineSeparator()).append("  - form desc: '").append(rev.getDescription()).append("'").append(System.lineSeparator()).append("  - form created: ").append(rev.getCreated()).append(System.lineSeparator()).append("  - form head: ").append(rev.getHead()).append(System.lineSeparator());
        for (DialobDocument.FormRevisionEntryDocument entry : rev.getEntries()) {
            this.log.append("    - ").append(entry.getRevisionName()).append(": ").append(entry.getFormId()).append(System.lineSeparator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String visitMigration(MigrationSupport.Migration mig) {
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            new MigrationSupport(this.config.getMapper()).write(mig, out);
            String string = new String(out.toByteArray(), StandardCharsets.UTF_8);
            return string;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public CreateReleaseVisitor(DialobClientConfig config, DialobComposer.ComposerState state) {
        this.config = config;
        this.state = state;
    }

    public static class Result {
        private DialobStore.CreateStoreEntity storeEntity;
        private DialobComposer.ComposerReleaseState releaseState;

        Result(DialobStore.CreateStoreEntity storeEntity, DialobComposer.ComposerReleaseState releaseState) {
            this.storeEntity = storeEntity;
            this.releaseState = releaseState;
        }

        public static ResultBuilder builder() {
            return new ResultBuilder();
        }

        public DialobStore.CreateStoreEntity getStoreEntity() {
            return this.storeEntity;
        }

        public DialobComposer.ComposerReleaseState getReleaseState() {
            return this.releaseState;
        }

        public void setStoreEntity(DialobStore.CreateStoreEntity storeEntity) {
            this.storeEntity = storeEntity;
        }

        public void setReleaseState(DialobComposer.ComposerReleaseState releaseState) {
            this.releaseState = releaseState;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DialobStore.CreateStoreEntity this$storeEntity = this.getStoreEntity();
            DialobStore.CreateStoreEntity other$storeEntity = other.getStoreEntity();
            if (this$storeEntity == null ? other$storeEntity != null : !this$storeEntity.equals(other$storeEntity)) {
                return false;
            }
            DialobComposer.ComposerReleaseState this$releaseState = this.getReleaseState();
            DialobComposer.ComposerReleaseState other$releaseState = other.getReleaseState();
            return !(this$releaseState == null ? other$releaseState != null : !this$releaseState.equals(other$releaseState));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DialobStore.CreateStoreEntity $storeEntity = this.getStoreEntity();
            result = result * 59 + ($storeEntity == null ? 43 : $storeEntity.hashCode());
            DialobComposer.ComposerReleaseState $releaseState = this.getReleaseState();
            result = result * 59 + ($releaseState == null ? 43 : $releaseState.hashCode());
            return result;
        }

        public String toString() {
            return "CreateReleaseVisitor.Result(storeEntity=" + this.getStoreEntity() + ", releaseState=" + this.getReleaseState() + ")";
        }

        public static class ResultBuilder {
            private DialobStore.CreateStoreEntity storeEntity;
            private DialobComposer.ComposerReleaseState releaseState;

            ResultBuilder() {
            }

            public ResultBuilder storeEntity(DialobStore.CreateStoreEntity storeEntity) {
                this.storeEntity = storeEntity;
                return this;
            }

            public ResultBuilder releaseState(DialobComposer.ComposerReleaseState releaseState) {
                this.releaseState = releaseState;
                return this;
            }

            public Result build() {
                return new Result(this.storeEntity, this.releaseState);
            }

            public String toString() {
                return "CreateReleaseVisitor.Result.ResultBuilder(storeEntity=" + this.storeEntity + ", releaseState=" + this.releaseState + ")";
            }
        }
    }
}

