/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.composer;

import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobComposer;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobErrorHandler;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.ImmutableCreateStoreEntity;
import io.dialob.client.api.ImmutableFormRevisionDocument;
import io.dialob.client.spi.exceptions.ErrorMsgBuilder;
import io.dialob.client.spi.support.DialobAssert;
import io.dialob.client.spi.support.OidUtils;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class CreateFormDocumentVisitor {
    private final DialobComposer.ComposerState state;
    private final DialobDocument.FormDocument asset;
    private final DialobClient client;

    public List<DialobStore.StoreCommand> visit() {
        DialobAssert.notNull(this.asset, () -> "asset can't be null!");
        DialobAssert.notNull(this.state, () -> "state can't be null!");
        DialobAssert.notNull(this.client, () -> "client can't be null!");
        this.visitValidations();
        LocalDateTime created = LocalDateTime.now();
        String formId = this.asset.getId() == null ? OidUtils.gen() : this.asset.getId();
        ImmutableFormRevisionDocument rev = ImmutableFormRevisionDocument.builder().id(null).version(null).name(this.asset.getData().getName()).head(formId).created(created).updated(created).build();
        return Arrays.asList(ImmutableCreateStoreEntity.builder().body(this.client.getConfig().getMapper().toStoreBody(rev)).bodyType(DialobDocument.DocumentType.FORM_REV).build(), ImmutableCreateStoreEntity.builder().id(formId).version(this.asset.getVersion()).body(this.client.getConfig().getMapper().toStoreBody(this.asset)).bodyType(DialobDocument.DocumentType.FORM).build());
    }

    private void visitValidations() {
        if (StringUtils.isEmpty((CharSequence)this.asset.getData().getName().trim())) {
            throw new DialobErrorHandler.DatabaseException(new ErrorMsgBuilder("Document name not valid valid!").field("provided name", "'" + this.asset.getData() + "'").build());
        }
        if (this.asset.getData().getId() != null && this.state.getForms().containsKey(this.asset.getData().getId())) {
            throw new DialobErrorHandler.DatabaseException(new ErrorMsgBuilder("Document id not valid valid!").field("provided id", "'" + this.asset.getData() + "' already exists!").build());
        }
        Optional<DialobDocument.FormRevisionDocument> decision = this.state.getRevs().values().stream().filter(e -> e.getName().trim().equals(this.asset.getData().getName().trim())).findFirst();
        if (decision.isPresent()) {
            throw new DialobErrorHandler.DatabaseException(new ErrorMsgBuilder("Document name not valid valid!").field("existing id", "'" + decision.get().getId() + "'").field("existing name", "'" + decision.get().getName() + "'").field("provided name", "'" + this.asset.getData() + "'").build());
        }
    }

    public CreateFormDocumentVisitor(DialobComposer.ComposerState state, DialobDocument.FormDocument asset, DialobClient client) {
        this.state = state;
        this.asset = asset;
        this.client = client;
    }
}

