/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.composer;

import io.dialob.api.form.Form;
import io.dialob.api.form.ImmutableForm;
import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobComposer;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobErrorHandler;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.ImmutableFormDocument;
import io.dialob.client.spi.composer.CreateFormDocumentVisitor;
import io.dialob.client.spi.exceptions.ErrorMsgBuilder;
import java.time.LocalDateTime;
import java.util.List;

public class CopyAsEntityVisitor {
    private final DialobComposer.ComposerState state;
    private final String assetId;
    private final DialobClient client;
    private final String copyToName;

    public List<DialobStore.StoreCommand> visit() {
        DialobDocument.FormDocument src = this.state.getForms().get(this.assetId);
        if (src == null) {
            throw this.notFound();
        }
        ImmutableForm newForm = ImmutableForm.builder().from(src.getData()).id(null).rev(null).name(this.copyToName).build();
        ImmutableFormDocument newDoc = ImmutableFormDocument.builder().name(this.copyToName).created(LocalDateTime.now()).updated(LocalDateTime.now()).description(src.getDescription()).data((Form)newForm).build();
        return new CreateFormDocumentVisitor(this.state, newDoc, this.client).visit();
    }

    private DialobErrorHandler.DocumentNotFoundException notFound() {
        return new DialobErrorHandler.DocumentNotFoundException(new ErrorMsgBuilder("Document not found!").field("form id", this.assetId).field("copyToName", this.copyToName).build());
    }

    public CopyAsEntityVisitor(DialobComposer.ComposerState state, String assetId, DialobClient client, String copyToName) {
        this.state = state;
        this.assetId = assetId;
        this.client = client;
        this.copyToName = copyToName;
    }
}

