/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi.composer;

import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.ImmutableComposerState;

public class ComposerEntityMapper {
    public static DialobClient.EnvirBuilder toEnvir(DialobClient.EnvirBuilder envirBuilder, DialobStore.StoreState source) {
        source.getRevs().values().forEach(v -> envirBuilder.addCommand().id(v.getId()).version(v.getVersion()).rev((DialobStore.StoreEntity)v).build());
        source.getForms().values().forEach(v -> envirBuilder.addCommand().id(v.getId()).version(v.getVersion()).form((DialobStore.StoreEntity)v).build());
        source.getTags().values().forEach(v -> envirBuilder.addCommand().id(v.getId()).version(v.getVersion()).release((DialobStore.StoreEntity)v).build());
        return envirBuilder;
    }

    public static void toComposer(ImmutableComposerState.Builder builder, DialobClient.ProgramEnvirValue wrapper) {
        switch (wrapper.getSource().getBodyType()) {
            case FORM: {
                builder.putForms(wrapper.getDocument().getId(), (DialobDocument.FormDocument)wrapper.getDocument());
                break;
            }
            case FORM_REV: {
                builder.putRevs(wrapper.getDocument().getId(), (DialobDocument.FormRevisionDocument)wrapper.getDocument());
                break;
            }
            case RELEASE: {
                builder.putReleases(wrapper.getDocument().getId(), (DialobDocument.FormReleaseDocument)wrapper.getDocument());
                break;
            }
        }
    }
}

