/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.api.form.Form;
import io.dialob.api.form.ImmutableForm;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobErrorHandler;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.ImmutableFormDocument;
import io.dialob.client.api.ImmutableFormReleaseDocument;
import io.dialob.client.api.ImmutableFormRevisionDocument;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class DialobTypesMapperImpl
implements DialobClient.TypesMapper {
    private final ObjectMapper objectMapper;

    @Override
    public String toJson(Object anyObject) {
        return this.doInMapper(om -> om.writeValueAsString(anyObject));
    }

    @Override
    public DialobDocument.FormDocument readFormDoc(String entity) {
        return this.doInMapper(om -> (DialobDocument.FormDocument)om.readValue(entity, DialobDocument.FormDocument.class));
    }

    @Override
    public Questionnaire readQuestionnaire(InputStream entity) {
        return this.doInMapper(om -> (Questionnaire)om.readValue(entity, Questionnaire.class));
    }

    @Override
    public String toString(InputStream entity) {
        return this.doInMapper(om -> new String(entity.readAllBytes(), StandardCharsets.UTF_8));
    }

    @Override
    public String toStoreBody(DialobDocument.FormRevisionDocument anyObject) {
        return this.doInMapper(om -> om.writeValueAsString((Object)ImmutableFormRevisionDocument.builder().from(anyObject).version(null).id(null).build()));
    }

    @Override
    public String toStoreBody(DialobDocument.FormDocument anyObject) {
        return this.doInMapper(om -> om.writeValueAsString((Object)ImmutableForm.builder().from(anyObject.getData()).rev(null).id(null).build()));
    }

    @Override
    public String toStoreBody(DialobDocument.FormReleaseDocument anyObject) {
        return this.doInMapper(om -> om.writeValueAsString((Object)ImmutableFormReleaseDocument.builder().from(anyObject).version(null).id(null).build()));
    }

    @Override
    public Form readForm(String entity) {
        return this.doInMapper(om -> (Form)om.readValue(entity, Form.class));
    }

    @Override
    public DialobDocument.FormReleaseDocument readReleaseDoc(String entity) {
        return this.doInMapper(om -> (DialobDocument.FormReleaseDocument)om.readValue(entity, DialobDocument.FormReleaseDocument.class));
    }

    @Override
    public DialobDocument.FormRevisionDocument readFormRevDoc(String entity) {
        return this.doInMapper(om -> (DialobDocument.FormRevisionDocument)om.readValue(entity, DialobDocument.FormRevisionDocument.class));
    }

    @Override
    public DialobDocument.FormReleaseDocument toFormReleaseDoc(DialobStore.StoreEntity store) {
        return this.doInMapper(om -> {
            DialobDocument.FormReleaseDocument from = (DialobDocument.FormReleaseDocument)om.readValue(store.getBody(), DialobDocument.FormReleaseDocument.class);
            return ImmutableFormReleaseDocument.builder().from(from).version(store.getId()).id(store.getVersion()).build();
        });
    }

    @Override
    public DialobDocument.FormRevisionDocument toFormRevDoc(DialobStore.StoreEntity store) {
        return this.doInMapper(om -> {
            DialobDocument.FormRevisionDocument from = (DialobDocument.FormRevisionDocument)om.readValue(store.getBody(), DialobDocument.FormRevisionDocument.class);
            return ImmutableFormRevisionDocument.builder().from(from).version(store.getVersion()).id(store.getId()).build();
        });
    }

    @Override
    public DialobDocument.FormDocument toFormDoc(DialobStore.StoreEntity store) {
        return this.doInMapper(om -> {
            ImmutableForm data = ImmutableForm.builder().from((Form)om.readValue(store.getBody(), Form.class)).id(store.getId()).rev(store.getVersion()).build();
            return ImmutableFormDocument.builder().version(store.getVersion()).id(store.getId()).name(data.getName() == null ? data.getId() : data.getName()).created(data.getMetadata().getCreated() == null ? LocalDateTime.now() : LocalDateTime.ofInstant(data.getMetadata().getCreated().toInstant(), ZoneId.systemDefault())).updated(data.getMetadata().getLastSaved() == null ? LocalDateTime.now() : LocalDateTime.ofInstant(data.getMetadata().getLastSaved().toInstant(), ZoneId.systemDefault())).data((Form)data).build();
        });
    }

    public <T> T doInMapper(MapperFunction<T> input) {
        try {
            return input.apply(this.objectMapper);
        }
        catch (IOException e) {
            throw new DialobJsonException(e.getMessage(), e);
        }
    }

    public DialobTypesMapperImpl(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public static class DialobJsonException
    extends RuntimeException
    implements DialobErrorHandler.DialobClientException {
        private static final long serialVersionUID = -7154685569622201632L;

        public DialobJsonException(String message, Throwable cause) {
            super(message, cause);
        }

        public DialobJsonException(String message) {
            super(message);
        }
    }

    @FunctionalInterface
    private static interface MapperFunction<T> {
        public T apply(ObjectMapper var1) throws IOException;
    }
}

