/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi;

import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.ImmutableStoreEntity;
import io.dialob.client.api.ImmutableStoreExceptionMsg;
import io.dialob.client.spi.exceptions.StoreException;
import io.dialob.client.spi.store.DialobStoreConfig;
import io.dialob.client.spi.store.DocumentQueryBuilder;
import io.dialob.client.spi.store.ImmutableDialobStoreConfig;
import io.dialob.client.spi.store.PersistenceCommands;
import io.dialob.client.spi.support.DialobAssert;
import io.dialob.client.spi.support.OidUtils;
import io.dialob.client.spi.support.Sha2;
import io.resys.thena.docdb.api.DocDB;
import io.resys.thena.docdb.api.actions.CommitActions;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.actions.RepoActions;
import io.resys.thena.docdb.api.models.Objects;
import io.smallrye.mutiny.Uni;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DialobStoreTemplate
extends PersistenceCommands
implements DialobStore {
    private static final Comparator<DialobStore.StoreCommand> COMP = (a, b) -> Sha2.blob(a.toString()).compareTo(Sha2.blob(b.toString()));

    public DialobStoreTemplate(DialobStoreConfig config) {
        super(config);
    }

    @Override
    public String getRepoName() {
        return this.config.getRepoName();
    }

    @Override
    public String getHeadName() {
        return this.config.getHeadName();
    }

    @Override
    public DialobStore.StoreRepoBuilder repo() {
        return new DialobStore.StoreRepoBuilder(){
            private String repoName;
            private String headName;

            @Override
            public DialobStore.StoreRepoBuilder repoName(String repoName) {
                this.repoName = repoName;
                return this;
            }

            @Override
            public DialobStore.StoreRepoBuilder headName(String headName) {
                this.headName = headName;
                return this;
            }

            @Override
            public Uni<DialobStore> create() {
                DialobAssert.notNull(this.repoName, () -> "repoName must be defined!");
                DocDB client = DialobStoreTemplate.this.config.getClient();
                Uni newRepo = client.repo().create().name(this.repoName).build();
                return newRepo.onItem().transform(repoResult -> {
                    if (repoResult.getStatus() != RepoActions.RepoStatus.OK) {
                        throw new StoreException("REPO_CREATE_FAIL", null, ImmutableStoreExceptionMsg.builder().id(repoResult.getStatus().toString()).value(this.repoName).addAllArgs(repoResult.getMessages().stream().map(message -> message.getText()).collect(Collectors.toList())).build());
                    }
                    return this.build();
                });
            }

            @Override
            public DialobStore build() {
                DialobAssert.notNull(this.repoName, () -> "repoName must be defined!");
                return new DialobStoreTemplate(ImmutableDialobStoreConfig.builder().from(DialobStoreTemplate.this.config).repoName(this.repoName).headName(this.headName == null ? DialobStoreTemplate.this.config.getHeadName() : this.headName).build());
            }

            @Override
            public Uni<Boolean> createIfNot() {
                DocDB client = DialobStoreTemplate.this.config.getClient();
                return client.repo().query().id(DialobStoreTemplate.this.config.getRepoName()).get().onItem().transformToUni(repo -> {
                    if (repo == null) {
                        return client.repo().create().name(DialobStoreTemplate.this.config.getRepoName()).build().onItem().transform(newRepo -> true);
                    }
                    return Uni.createFrom().item((Object)true);
                });
            }
        };
    }

    @Override
    public DialobStore.QueryBuilder query() {
        return new DocumentQueryBuilder(this.config);
    }

    @Override
    public Uni<DialobStore.StoreEntity> create(DialobStore.CreateStoreEntity newType) {
        String gid = newType.getId() == null ? this.gid(newType.getBodyType()) : newType.getId();
        ImmutableStoreEntity entity = ImmutableStoreEntity.builder().id(gid).version(StringUtils.isEmpty((CharSequence)newType.getVersion()) ? OidUtils.gen() : newType.getVersion()).body(newType.getBody()).bodyType(newType.getBodyType()).build();
        return super.save(entity);
    }

    @Override
    public Uni<DialobStore.StoreEntity> update(DialobStore.UpdateStoreEntity updateType) {
        Uni<DialobStoreConfig.EntityState> query = this.getEntityState(updateType.getId());
        return query.onItem().transformToUni(state -> {
            if (!state.getEntity().getVersion().equals(updateType.getVersion())) {
                throw new StoreException("VERSION_LOCKING_ERROR", null, ImmutableStoreExceptionMsg.builder().id("VERSION_LOCKING_ERROR_ON_UPDATE").value("Version check mismatch on update, you provided: " + updateType.getVersion() + ", store expecting: " + state.getEntity().getVersion() + "!").args(Arrays.asList(state.getEntity().getVersion(), updateType.getVersion())).build());
            }
            ImmutableStoreEntity entity = ImmutableStoreEntity.builder().from(state.getEntity()).version(OidUtils.gen()).id(updateType.getId()).bodyType(state.getEntity().getBodyType()).body(updateType.getBody()).build();
            return super.save(entity);
        });
    }

    @Override
    public Uni<List<DialobStore.StoreEntity>> batch(List<DialobStore.StoreCommand> batchType) {
        List create = batchType.stream().filter(e -> e instanceof DialobStore.CreateStoreEntity).map(e -> (DialobStore.CreateStoreEntity)e).sorted(COMP).collect(Collectors.toList());
        List update = batchType.stream().filter(e -> e instanceof DialobStore.UpdateStoreEntity).map(e -> (DialobStore.UpdateStoreEntity)e).sorted(COMP).collect(Collectors.toList());
        List del = batchType.stream().filter(e -> e instanceof DialobStore.DeleteStoreEntity).map(e -> (DialobStore.DeleteStoreEntity)e).sorted(COMP).collect(Collectors.toList());
        CommitActions.HeadCommitBuilder commitBuilder = this.config.getClient().commit().head().head(this.config.getRepoName(), this.config.getHeadName()).message("Save batch with new: " + create.size() + " , updated: " + update.size() + " and deleted: " + del.size() + " entries").parentIsLatest().author(this.config.getAuthorProvider().getAuthor());
        return this.get().onItem().transformToUni(currentState -> {
            ArrayList<String> ids = new ArrayList<String>();
            for (DialobStore.StoreCommand toBeSaved : create) {
                String gid = toBeSaved.getId() == null ? this.gid(toBeSaved.getBodyType()) : toBeSaved.getId();
                ImmutableStoreEntity entity = ImmutableStoreEntity.builder().id(gid).version(StringUtils.isEmpty((CharSequence)toBeSaved.getVersion()) ? OidUtils.gen() : toBeSaved.getVersion()).body(toBeSaved.getBody()).bodyType(toBeSaved.getBodyType()).build();
                commitBuilder.append(entity.getId(), this.config.getSerializer().toString(entity));
                ids.add(gid);
            }
            for (DialobStore.StoreCommand toBeSaved : update) {
                ImmutableStoreEntity entity = ImmutableStoreEntity.builder().id(toBeSaved.getId()).version(OidUtils.gen()).body(toBeSaved.getBody()).bodyType(toBeSaved.getBodyType()).build();
                DialobStore.StoreEntity currentValue = super.getEntityFromState((DialobStore.StoreState)currentState, toBeSaved.getId());
                if (!currentValue.getVersion().equals(toBeSaved.getVersion())) {
                    throw new StoreException("VERSION_LOCKING_ERROR", null, ImmutableStoreExceptionMsg.builder().id("VERSION_LOCKING_ERROR_ON_UPDATE_IN_BATCH").value("Version check mismatch on update in batch, you provided: " + toBeSaved.getVersion() + ", store expecting: " + currentValue.getVersion() + "!").args(Arrays.asList(currentValue.getVersion(), toBeSaved.getVersion())).build());
                }
                commitBuilder.append(entity.getId(), this.config.getSerializer().toString(entity));
                ids.add(entity.getId());
            }
            for (DialobStore.DeleteStoreEntity toBeDeleted : del) {
                DialobStore.StoreEntity currentValue = super.getEntityFromState((DialobStore.StoreState)currentState, toBeDeleted.getId());
                if (!currentValue.getVersion().equals(toBeDeleted.getVersion())) {
                    throw new StoreException("VERSION_LOCKING_ERROR", null, ImmutableStoreExceptionMsg.builder().id("VERSION_LOCKING_ERROR_ON_DELETE_IN_BATCH").value("Version check mismatch on delete in batch, you provided: " + toBeDeleted.getVersion() + ", store expecting: " + currentValue.getVersion() + "!").args(Arrays.asList(currentValue.getVersion(), toBeDeleted.getVersion())).build());
                }
                commitBuilder.remove(toBeDeleted.getId());
            }
            return commitBuilder.build().onItem().transformToUni(commit -> {
                if (commit.getStatus() == CommitActions.CommitStatus.OK) {
                    return this.config.getClient().objects().blobState().repo(this.config.getRepoName()).anyId(this.config.getHeadName()).blobNames(ids).list().onItem().transform(states -> {
                        if (states.getStatus() != ObjectsActions.ObjectsStatus.OK) {
                            throw new StoreException("LIST_FAIL", null, this.convertMessages2((ObjectsActions.ObjectsResult<ObjectsActions.BlobObjects>)states));
                        }
                        ArrayList<DialobStore.StoreEntity> entities = new ArrayList<DialobStore.StoreEntity>();
                        for (Objects.Blob state : ((ObjectsActions.BlobObjects)states.getObjects()).getBlob()) {
                            DialobStore.StoreEntity start = this.config.getDeserializer().fromString(state);
                            entities.add(start);
                        }
                        return entities;
                    });
                }
                throw new StoreException("SAVE_FAIL", null, this.convertMessages((CommitActions.CommitResult)commit));
            });
        });
    }

    @Override
    public Uni<DialobStore.StoreEntity> delete(DialobStore.DeleteStoreEntity deleteType) {
        Uni<DialobStoreConfig.EntityState> query = this.getEntityState(deleteType.getId());
        return query.onItem().transformToUni(state -> this.delete(state.getEntity()));
    }

    private String gid(DialobDocument.DocumentType type) {
        return this.config.getGidProvider().getNextId(type);
    }
}

