/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.ImmutableStoreEntity;
import io.dialob.client.spi.DialobStoreTemplate;
import io.dialob.client.spi.store.BlobDeserializer;
import io.dialob.client.spi.store.DialobStoreConfig;
import io.dialob.client.spi.store.ImmutableDialobStoreConfig;
import io.dialob.client.spi.support.DialobAssert;
import io.dialob.client.spi.support.OidUtils;
import io.resys.thena.docdb.api.DocDB;
import io.resys.thena.docdb.file.DocDBFactoryFile;
import io.resys.thena.docdb.file.FileErrors;
import io.resys.thena.docdb.file.spi.FilePoolImpl;
import io.resys.thena.docdb.file.tables.Table;
import io.resys.thena.docdb.spi.ErrorHandler;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialobStoreFileImpl
extends DialobStoreTemplate
implements DialobStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobStoreFileImpl.class);

    public DialobStoreFileImpl(DialobStoreConfig config) {
        super(config);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String repoName;
        private String headName;
        private ObjectMapper objectMapper;
        private DialobStoreConfig.GidProvider gidProvider;
        private DialobStoreConfig.AuthorProvider authorProvider;
        private String db;
        private Table.FilePool pool;

        public Builder repoName(String repoName) {
            this.repoName = repoName;
            return this;
        }

        public Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder gidProvider(DialobStoreConfig.GidProvider gidProvider) {
            this.gidProvider = gidProvider;
            return this;
        }

        public Builder authorProvider(DialobStoreConfig.AuthorProvider authorProvider) {
            this.authorProvider = authorProvider;
            return this;
        }

        public Builder pgPool(Table.FilePool pgPool) {
            this.pool = pgPool;
            return this;
        }

        public Builder headName(String headName) {
            this.headName = headName;
            return this;
        }

        public Builder pgDb(String pgDb) {
            this.db = pgDb;
            return this;
        }

        private DialobStoreConfig.GidProvider getGidProvider() {
            return this.gidProvider == null ? type -> OidUtils.gen() : this.gidProvider;
        }

        private DialobStoreConfig.AuthorProvider getAuthorProvider() {
            return this.authorProvider == null ? () -> "not-configured" : this.authorProvider;
        }

        private ObjectMapper getObjectMapper() {
            if (this.objectMapper == null) {
                return this.objectMapper;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.registerModule((Module)new GuavaModule());
            objectMapper.registerModule((Module)new JavaTimeModule());
            objectMapper.registerModule((Module)new Jdk8Module());
            return objectMapper;
        }

        public DialobStoreTemplate build() {
            DocDB thena;
            String headName;
            DialobAssert.notNull(this.repoName, () -> "repoName must be defined!");
            String string = headName = this.headName == null ? "main" : this.headName;
            if (LOGGER.isDebugEnabled()) {
                StringBuilder log = new StringBuilder().append(System.lineSeparator()).append("Configuring Thena: ").append(System.lineSeparator()).append("  repoName: '").append(this.repoName).append("'").append(System.lineSeparator()).append("  headName: '").append(headName).append("'").append(System.lineSeparator()).append("  objectMapper: '").append(this.objectMapper == null ? "configuring" : "provided").append("'").append(System.lineSeparator()).append("  gidProvider: '").append(this.gidProvider == null ? "configuring" : "provided").append("'").append(System.lineSeparator()).append("  authorProvider: '").append(this.authorProvider == null ? "configuring" : "provided").append("'").append(System.lineSeparator()).append("  db: '").append(this.db).append("'").append(System.lineSeparator());
                LOGGER.debug(log.toString());
            }
            if (this.pool == null) {
                DialobAssert.notNull(this.db, () -> "db must be defined!");
                FilePoolImpl pgPool = new FilePoolImpl(new File(this.db), this.objectMapper);
                thena = DocDBFactoryFile.create().client((Table.FilePool)pgPool).db(this.repoName).errorHandler((ErrorHandler)new FileErrors()).build();
            } else {
                thena = DocDBFactoryFile.create().client(this.pool).db(this.repoName).errorHandler((ErrorHandler)new FileErrors()).build();
            }
            ObjectMapper objectMapper = this.getObjectMapper();
            ImmutableDialobStoreConfig config = ImmutableDialobStoreConfig.builder().client(thena).repoName(this.repoName).headName(headName).gidProvider(this.getGidProvider()).serializer(entity -> {
                try {
                    return objectMapper.writeValueAsString((Object)ImmutableStoreEntity.builder().from(entity).build());
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }).deserializer(new BlobDeserializer(objectMapper)).authorProvider(this.getAuthorProvider()).build();
            return new DialobStoreTemplate(config);
        }
    }
}

