/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi;

import io.dialob.client.api.DialobCache;
import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobClientConfig;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.ImmutableDialobClientConfig;
import io.dialob.client.spi.DialobClientImpl;
import io.dialob.client.spi.support.DialobAssert;
import io.smallrye.mutiny.Uni;

public class DialobRepoBuilderImpl
implements DialobClient.RepoBuilder {
    private final DialobClientConfig config;
    private String repoName;
    private String headName;

    @Override
    public DialobClient.RepoBuilder repoName(String repoName) {
        this.repoName = repoName;
        return this;
    }

    @Override
    public DialobClient.RepoBuilder headName(String headName) {
        this.headName = headName;
        return this;
    }

    @Override
    public Uni<DialobClient> create() {
        DialobAssert.notNull(this.repoName, () -> "repoName must be defined!");
        return this.config.getStore().repo().repoName(this.repoName).headName(this.headName).create().onItem().transform(newStore -> {
            DialobCache newCache = this.config.getCache().withName(this.repoName);
            ImmutableDialobClientConfig newConfig = ImmutableDialobClientConfig.builder().from(this.config).cache(newCache).store((DialobStore)newStore).build();
            return new DialobClientImpl(newConfig);
        });
    }

    @Override
    public DialobClient build() {
        DialobAssert.notNull(this.repoName, () -> "repoName must be defined!");
        DialobStore newStore = this.config.getStore().repo().repoName(this.repoName).headName(this.headName).build();
        DialobCache newCache = this.config.getCache().withName(this.repoName);
        ImmutableDialobClientConfig newConfig = ImmutableDialobClientConfig.builder().from(this.config).cache(newCache).store(newStore).build();
        return new DialobClientImpl(newConfig);
    }

    public DialobRepoBuilderImpl(DialobClientConfig config) {
        this.config = config;
    }
}

