/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi;

import io.dialob.api.form.FormValidationError;
import io.dialob.client.api.DialobCache;
import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobClientConfig;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.ImmutableProgramMessage;
import io.dialob.client.api.ImmutableProgramWrapper;
import io.dialob.client.api.ImmutableReleaseWrapper;
import io.dialob.client.api.ImmutableRevisionWrapper;
import io.dialob.client.spi.program.ImmutableProgramEnvir;
import io.dialob.client.spi.program.ProgramBuilderImpl;
import io.dialob.compiler.DialobProgramErrorsException;
import io.dialob.compiler.DialobProgramFromFormCompiler;
import io.dialob.program.DialobProgram;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialobProgramEnvirFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobProgramEnvirFactory.class);
    private final DialobClientConfig config;
    private final DialobClient.TypesMapper mapper;
    private final DialobProgramFromFormCompiler compiler;
    private final DialobCache cache;
    private final List<String> visitedIds = new ArrayList<String>();
    private final List<String> cachlessIds = new ArrayList<String>();
    private final StringBuilder treelog = new StringBuilder();
    private final List<DialobClient.ProgramWrapper> programs = new ArrayList<DialobClient.ProgramWrapper>();
    private final List<DialobClient.ProgramEnvirValue<?>> envirValue = new ArrayList();
    private DialobClient.ProgramEnvir baseEnvir;

    public DialobProgramEnvirFactory(DialobClientConfig config) {
        this.mapper = config.getMapper();
        this.cache = config.getCache();
        this.compiler = config.getCompiler();
        this.config = config;
    }

    public DialobProgramEnvirFactory add(DialobClient.ProgramEnvir envir) {
        this.baseEnvir = envir;
        return this;
    }

    public DialobProgramEnvirFactory add(DialobStore.StoreEntity entity, boolean cachless) {
        if (cachless) {
            this.cachlessIds.add(entity.getId());
        }
        switch (entity.getBodyType()) {
            case FORM: {
                DialobClient.ProgramWrapper form = this.visitForm(entity);
                this.visitWrapper(form);
                break;
            }
            case FORM_REV: {
                DialobClient.RevisionWrapper rev = this.visitRevision(entity);
                this.visitWrapper(rev);
                break;
            }
            case RELEASE: {
                DialobClient.ReleaseWrapper rel = this.visitRelease(entity);
                this.visitWrapper(rel);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown command format type: '" + entity.getBodyType() + "'!");
            }
        }
        this.visitedIds.add(entity.getId());
        return this;
    }

    public DialobClient.ProgramEnvir build() {
        ImmutableProgramEnvir.Builder envir = ImmutableProgramEnvir.builder();
        if (this.baseEnvir != null) {
            this.baseEnvir.findAll().stream().filter(wrapper -> !this.visitedIds.contains(wrapper.getId())).forEach(wrapper -> this.visitWrapper((DialobClient.ProgramEnvirValue<?>)wrapper));
        }
        for (DialobClient.ProgramWrapper programWrapper : this.programs) {
            this.visitTreeLog(programWrapper);
            envir.add(programWrapper);
        }
        for (DialobClient.ProgramEnvirValue<DialobDocument.FormDocument> programEnvirValue : this.envirValue) {
            this.visitTreeLog(programEnvirValue);
            envir.add(programEnvirValue);
        }
        return envir.build();
    }

    private void visitWrapper(DialobClient.ProgramEnvirValue<?> value) {
        if (value instanceof DialobClient.ProgramWrapper) {
            this.programs.add((DialobClient.ProgramWrapper)value);
        } else {
            this.envirValue.add(value);
        }
    }

    private void visitTreeLog(DialobClient.ProgramEnvirValue<?> value) {
        if (value.getSource().getBodyType() == DialobDocument.DocumentType.FORM) {
            DialobClient.ProgramWrapper wrapper = (DialobClient.ProgramWrapper)value;
            String name = ((DialobDocument.FormDocument)wrapper.getDocument()).getName();
            this.treelog.append("  - ").append(name).append(": ").append((Object)wrapper.getStatus()).append(System.lineSeparator());
            if (wrapper.getStatus() != DialobClient.ProgramStatus.UP) {
                for (DialobClient.ProgramMessage error : wrapper.getErrors()) {
                    this.treelog.append("    - ").append(error.getId()).append(": ").append(error.getMsg()).append(System.lineSeparator());
                    if (error.getException() == null) continue;
                    String stack = ExceptionUtils.getStackTrace((Throwable)error.getException());
                    if (stack.length() > 100) {
                        stack = stack.substring(0, 100);
                    }
                    this.treelog.append("      ").append(stack).append(System.lineSeparator());
                }
            }
        }
    }

    private DialobClient.ProgramWrapper visitForm(DialobStore.StoreEntity src) {
        ImmutableProgramWrapper.Builder builder = ImmutableProgramWrapper.builder();
        builder.status(DialobClient.ProgramStatus.UP);
        DialobDocument.FormDocument ast = null;
        if (this.cachlessIds.contains(src.getId())) {
            ast = this.mapper.toFormDoc(src);
        } else {
            Optional<DialobDocument> cached = this.cache.getAst(src);
            if (cached.isPresent()) {
                ast = (DialobDocument.FormDocument)cached.get();
            } else {
                ast = this.mapper.toFormDoc(src);
                this.cache.setAst(ast, src);
            }
        }
        DialobProgram program = null;
        if (ast != null) {
            try {
                if (this.cachlessIds.contains(src.getId())) {
                    program = new ProgramBuilderImpl(this.compiler).form(ast).build();
                } else {
                    Optional<DialobProgram> cached = this.cache.getProgram(src);
                    if (cached.isPresent()) {
                        program = cached.get();
                    } else {
                        program = new ProgramBuilderImpl(this.compiler).form(ast).build();
                        this.cache.setProgram(program, src);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage() + System.lineSeparator() + "  - form source: " + src.getBody(), (Throwable)e);
                builder.status(DialobClient.ProgramStatus.PROGRAM_ERROR).addAllErrors(this.visitException(e));
            }
        }
        return builder.id(src.getId()).document(ast).program(Optional.ofNullable(program)).source(src).build();
    }

    private DialobClient.RevisionWrapper visitRevision(DialobStore.StoreEntity src) {
        DialobDocument.FormRevisionDocument ast = null;
        if (this.cachlessIds.contains(src.getId())) {
            ast = this.mapper.toFormRevDoc(src);
        } else {
            Optional<DialobDocument> cached = this.cache.getAst(src);
            if (cached.isPresent()) {
                ast = (DialobDocument.FormRevisionDocument)cached.get();
            } else {
                ast = this.mapper.toFormRevDoc(src);
                this.cache.setAst(ast, src);
            }
        }
        return ImmutableRevisionWrapper.builder().document(ast).source(src).build();
    }

    private DialobClient.ReleaseWrapper visitRelease(DialobStore.StoreEntity src) {
        DialobDocument.FormReleaseDocument ast = null;
        if (this.cachlessIds.contains(src.getId())) {
            ast = this.mapper.toFormReleaseDoc(src);
        } else {
            Optional<DialobDocument> cached = this.cache.getAst(src);
            if (cached.isPresent()) {
                ast = (DialobDocument.FormReleaseDocument)cached.get();
            } else {
                ast = this.mapper.toFormReleaseDoc(src);
                this.cache.setAst(ast, src);
            }
        }
        return ImmutableReleaseWrapper.builder().document(ast).source(src).build();
    }

    private List<DialobClient.ProgramMessage> visitException(Exception e) {
        ArrayList<DialobClient.ProgramMessage> msgs = new ArrayList<DialobClient.ProgramMessage>();
        if (e instanceof DialobProgramErrorsException) {
            ((DialobProgramErrorsException)e).getErrors().stream().map(error -> ImmutableProgramMessage.builder().id("compiler-error").src((FormValidationError)error).build()).forEach(msgs::add);
        }
        msgs.add(ImmutableProgramMessage.builder().id("exception").msg(e.getMessage() == null ? "no-desc-available" : e.getMessage().replaceAll("\"", "'")).exception(e).build());
        return msgs;
    }

    public DialobClientConfig getConfig() {
        return this.config;
    }
}

