/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.ImmutableStoreEntity;
import io.dialob.client.api.ImmutableStoreState;
import io.dialob.client.spi.composer.ReleaseDumpToStoreEntityVisitor;
import io.dialob.client.spi.store.StoreEntityLocation;
import io.dialob.client.spi.support.DialobAssert;
import io.smallrye.mutiny.Uni;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class DialobMemoryStore
implements DialobStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobMemoryStore.class);
    private final Map<String, DialobStore.StoreEntity> entities;
    private final DialobStore.StoreState state;

    public DialobMemoryStore(Map<String, DialobStore.StoreEntity> entities) {
        this.entities = entities;
        ImmutableStoreState.Builder builder = ImmutableStoreState.builder();
        block4: for (DialobStore.StoreEntity entity : entities.values()) {
            switch (entity.getBodyType()) {
                case FORM_REV: {
                    builder.putRevs(entity.getId(), entity);
                    continue block4;
                }
                case FORM: {
                    builder.putForms(entity.getId(), entity);
                    continue block4;
                }
            }
        }
        this.state = builder.build();
    }

    @Override
    public Uni<DialobStore.StoreEntity> create(DialobStore.CreateStoreEntity newType) {
        throw new RuntimeException("read only store!");
    }

    @Override
    public Uni<DialobStore.StoreEntity> update(DialobStore.UpdateStoreEntity updateType) {
        throw new RuntimeException("read only store!");
    }

    @Override
    public Uni<DialobStore.StoreEntity> delete(DialobStore.DeleteStoreEntity deleteType) {
        throw new RuntimeException("read only store!");
    }

    @Override
    public DialobStore.QueryBuilder query() {
        return new DialobStore.QueryBuilder(){

            @Override
            public Uni<DialobStore.StoreEntity> get(String id) {
                return Uni.createFrom().item(() -> DialobMemoryStore.this.entities.get(id));
            }

            @Override
            public Uni<DialobStore.StoreState> get() {
                return Uni.createFrom().item(() -> DialobMemoryStore.this.state);
            }
        };
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public DialobStore.StoreRepoBuilder repo() {
        throw new IllegalArgumentException("not implemented");
    }

    @Override
    public Uni<List<DialobStore.StoreEntity>> batch(List<DialobStore.StoreCommand> batchType) {
        throw new IllegalArgumentException("not implemented");
    }

    @Override
    public String getRepoName() {
        return "in-memory";
    }

    @Override
    public String getHeadName() {
        return "in-memory";
    }

    public static class Builder {
        private ObjectMapper objectMapper;
        private String path;
        private final ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        private StoreEntityLocation location;

        private List<Resource> list(String location) {
            try {
                LOGGER.info("Loading assets from: " + location + "!");
                ArrayList<Resource> files = new ArrayList<Resource>();
                for (Resource resource : this.resolver.getResources(location)) {
                    files.add(resource);
                }
                return files;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load asset from: " + location + "!" + e.getMessage(), e);
            }
        }

        private ImmutableStoreEntity.Builder readStoreEntity(Resource resource) {
            String content = this.readContents(resource);
            return ImmutableStoreEntity.builder().id(resource.getFilename()).version("static_location").body(content);
        }

        private String readContents(Resource entry) {
            try {
                return IOUtils.toString((InputStream)entry.getInputStream(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load asset content from: " + entry.getFilename() + "!" + e.getMessage(), e);
            }
        }

        public Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public DialobMemoryStore build() {
            DialobAssert.notNull(this.objectMapper, () -> "objectMapper must be defined!");
            this.location = new StoreEntityLocation(this.path == null ? "classpath*:assets/" : this.path);
            LOGGER.info("Dialob, starting in memory read-only store from: '" + this.path + "'");
            StringBuilder migLog = new StringBuilder();
            HashMap<String, DialobStore.StoreEntity> entities = new HashMap<String, DialobStore.StoreEntity>();
            List<Resource> migration = this.list(this.location.getMigrationRegex());
            DialobAssert.isTrue(migration.size() < 2, () -> "Only one migration dump can be defined in: '" + this.location.getMigrationRegex() + "'!");
            migration.stream().forEach(r -> {
                migLog.append("Loading assets from migration: " + r.getFilename()).append(System.lineSeparator());
                new ReleaseDumpToStoreEntityVisitor((Resource)r, this.objectMapper).visit(entity -> {
                    migLog.append("  - ").append(entity.getId()).append("/").append((Object)entity.getBodyType()).append(System.lineSeparator());
                    entities.put(entity.getId(), (DialobStore.StoreEntity)entity);
                });
            });
            migLog.append(System.lineSeparator());
            this.list(this.location.getFormTagRegex()).stream().forEach(r -> {
                ImmutableStoreEntity entity = this.readStoreEntity((Resource)r).bodyType(DialobDocument.DocumentType.FORM_REV).build();
                migLog.append("  - ").append(entity.getId()).append("/").append((Object)entity.getBodyType()).append("/").append(System.lineSeparator());
                entities.put(entity.getId(), entity);
            });
            this.list(this.location.getFormRegex()).stream().forEach(r -> {
                ImmutableStoreEntity entity = this.readStoreEntity((Resource)r).bodyType(DialobDocument.DocumentType.FORM).build();
                migLog.append("  - ").append(entity.getId()).append("/").append((Object)entity.getBodyType()).append("/").append(System.lineSeparator());
                entities.put(entity.getId(), entity);
            });
            LOGGER.info(migLog.toString());
            return new DialobMemoryStore(entities);
        }
    }
}

