/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi;

import io.dialob.api.form.Form;
import io.dialob.api.questionnaire.ContextValue;
import io.dialob.api.questionnaire.ImmutableContextValue;
import io.dialob.api.questionnaire.ImmutableQuestionnaire;
import io.dialob.api.questionnaire.ImmutableQuestionnaireMetadata;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobComposer;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobFill;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.ImmutableFillEntry;
import io.dialob.client.api.ImmutableStoreExceptionMsg;
import io.dialob.client.spi.DialobComposerImpl;
import io.dialob.client.spi.exceptions.StoreException;
import io.dialob.client.spi.support.DialobAssert;
import io.smallrye.mutiny.Uni;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.immutables.value.Value;

public class DialobInMemoryFill
implements DialobFill {
    private static final String CACHE_PREFIX = DialobInMemoryFill.class.getCanonicalName();
    private final CacheManager cacheManager;
    private final DialobClient client;
    private final String cacheName;

    private Cache<String, DialobFill.FillEntry> getCache() {
        return this.cacheManager.getCache(this.cacheName, String.class, DialobFill.FillEntry.class);
    }

    @Override
    public DialobFill.FillBuilder create() {
        return new DialobFill.FillBuilder(){
            private String formId;
            private String language;
            private final List<ContextValue> contextValues = new ArrayList<ContextValue>();

            @Override
            public DialobFill.FillBuilder formId(String formId) {
                this.formId = formId;
                return this;
            }

            @Override
            public DialobFill.FillBuilder language(String language) {
                this.language = language;
                return this;
            }

            @Override
            public DialobFill.FillBuilder contextValues(Collection<ContextValue> contextValues) {
                this.contextValues.addAll(contextValues);
                return this;
            }

            @Override
            public DialobFill.FillBuilder contextValues(Map<String, Object> contextValues) {
                contextValues.forEach((key, value) -> this.contextValues.add((ContextValue)ImmutableContextValue.builder().id(key).value(value).build()));
                return this;
            }

            @Override
            public Uni<DialobFill.FillEntry> build() {
                DialobAssert.notEmpty(this.formId, () -> "formId can't be empty!");
                DialobAssert.notEmpty(this.language, () -> "language can't be empty!");
                ImmutableQuestionnaireMetadata metadata = ImmutableQuestionnaireMetadata.builder().formId(this.formId).formRev("LATEST").language(this.language).build();
                ImmutableQuestionnaire next = ImmutableQuestionnaire.builder().metadata((Questionnaire.Metadata)metadata).addAllContext(this.contextValues).build();
                return DialobInMemoryFill.this.save((Questionnaire)next).onItem().transform(saved -> {
                    Cache<String, DialobFill.FillEntry> cache = DialobInMemoryFill.this.getCache();
                    return (DialobFill.FillEntry)cache.get((Object)saved.getId());
                });
            }
        };
    }

    @Override
    public DialobFill.FillQuery query() {
        return new DialobFill.FillQuery(){
            private String formId;

            @Override
            public Uni<Questionnaire> get(String id) {
                Cache<String, DialobFill.FillEntry> cache = DialobInMemoryFill.this.getCache();
                DialobFill.FillEntry entry = (DialobFill.FillEntry)cache.get((Object)id);
                if (entry != null) {
                    return Uni.createFrom().item((Object)entry.getQuestionnaire());
                }
                Optional<Cache.Entry> result = StreamSupport.stream(cache.spliterator(), true).filter(e -> id.contains(((DialobFill.FillEntry)e.getValue()).getQuestionnaire().getId())).findFirst();
                if (result.isEmpty()) {
                    throw new StoreException("FILL_NOT_FOUND", null, ImmutableStoreExceptionMsg.builder().id("FILL_NOT_FOUND").value("Fill not found with id: " + id).addArgs(id).build());
                }
                return Uni.createFrom().item((Object)((DialobFill.FillEntry)result.get().getValue()).getQuestionnaire());
            }

            @Override
            public DialobFill.FillQuery formId(String formId) {
                this.formId = formId;
                return this;
            }

            @Override
            public Uni<List<Questionnaire>> find() {
                Cache<String, DialobFill.FillEntry> cache = DialobInMemoryFill.this.getCache();
                List result = StreamSupport.stream(cache.spliterator(), true).filter(e -> ((DialobFill.FillEntry)e.getValue()).getForm().getId().equals(this.formId)).map(e -> ((DialobFill.FillEntry)e.getValue()).getQuestionnaire()).collect(Collectors.toList());
                return Uni.createFrom().item(result);
            }
        };
    }

    @Override
    public Uni<Questionnaire> save(Questionnaire init) {
        DialobAssert.notNull(init, () -> "init can't be null!");
        Cache<String, DialobFill.FillEntry> cache = this.getCache();
        DialobFill.FillEntry saved = init.getId() == null ? null : (DialobFill.FillEntry)cache.get((Object)init.getId());
        Object next = saved == null ? ImmutableQuestionnaire.builder().id(UUID.randomUUID().toString()).from(init).build() : init;
        return this.client.store().query().get().onItem().transform(arg_0 -> this.lambda$save$1((Questionnaire)next, cache, arg_0));
    }

    public static Builder builder() {
        return new Builder();
    }

    private static String createName(String name) {
        return CACHE_PREFIX + "-" + name;
    }

    public DialobInMemoryFill(CacheManager cacheManager, DialobClient client, String cacheName) {
        this.cacheManager = cacheManager;
        this.client = client;
        this.cacheName = cacheName;
    }

    private /* synthetic */ Questionnaire lambda$save$1(Questionnaire next, Cache cache, DialobStore.StoreState state) {
        ImmutableQuestionnaire toBeSaved = ImmutableQuestionnaire.builder().from(next).rev(UUID.randomUUID().toString()).build();
        String formId = toBeSaved.getMetadata().getFormId();
        DialobComposer.ComposerState composerState = DialobComposerImpl.composerState(this.client, state);
        DialobDocument.FormDocument form = composerState.getForms().get(formId);
        if (form == null) {
            throw new StoreException("FORM_NOT_FOUND", null, ImmutableStoreExceptionMsg.builder().id("FORM_NOT_FOUND").value("form not found with id: " + formId).addArgs(formId).build());
        }
        ImmutableFillEntry entry = ImmutableFillEntry.builder().id(toBeSaved.getId()).questionnaire((Questionnaire)toBeSaved).form(form.getData()).build();
        cache.put((Object)entry.getId(), (Object)entry);
        return entry.getQuestionnaire();
    }

    public static class Builder {
        public DialobInMemoryFill build(String name, DialobClient client) {
            String cacheName = DialobInMemoryFill.createName(name);
            int cacheHeap = 300;
            CacheManager cacheManager = CacheManagerBuilder.newCacheManagerBuilder().withCache(cacheName, (org.ehcache.config.Builder)CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, DialobFill.FillEntry.class, (org.ehcache.config.Builder)ResourcePoolsBuilder.heap((long)300L))).build();
            cacheManager.init();
            return new DialobInMemoryFill(cacheManager, client, cacheName);
        }
    }

    @Value.Immutable
    static interface FillCacheEntry
    extends Serializable {
        public String getId();

        public Questionnaire getQuestionnaire();

        public Form getForm();
    }
}

