/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi;

import io.dialob.api.proto.Action;
import io.dialob.api.proto.Actions;
import io.dialob.api.proto.ImmutableAction;
import io.dialob.api.proto.ImmutableActions;
import io.dialob.client.api.DialobErrorHandler;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialobErrorHandlerImpl
implements DialobErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobErrorHandlerImpl.class);
    private final boolean reportStackTrace;

    @Override
    public Actions toActions(Exception e) {
        ImmutableActions.Builder actions = ImmutableActions.builder();
        if (e instanceof DialobErrorHandler.DocumentNotFoundException) {
            DialobErrorHandler.DocumentNotFoundException dex = (DialobErrorHandler.DocumentNotFoundException)e;
            LOGGER.debug("Action QUESTIONNAIRE_NOT_FOUND: backend response '{}'", (Object)e.getMessage());
            actions.addActions((Action)ImmutableAction.builder().type(Action.Type.SERVER_ERROR).serverEvent(Boolean.valueOf(true)).message("not found").id(dex.getId()).build());
        } else {
            LOGGER.debug("Error in websocket handler", (Throwable)e);
            actions.actions(Collections.singletonList(this.createNotifyServerErrorAction(e)));
        }
        return actions.build();
    }

    private Action createNotifyServerErrorAction(Exception e) {
        ImmutableAction.Builder action = ImmutableAction.builder().type(Action.Type.SERVER_ERROR).serverEvent(Boolean.valueOf(true));
        if (this.reportStackTrace) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            action.message(e.getMessage());
            action.trace(sw.toString());
        }
        return action.build();
    }

    public DialobErrorHandlerImpl(boolean reportStackTrace) {
        this.reportStackTrace = reportStackTrace;
    }
}

