/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi;

import io.dialob.client.api.DialobCache;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.ImmutableCacheEntry;
import io.dialob.program.DialobProgram;
import java.util.ArrayList;
import java.util.Optional;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialobEhCache
implements DialobCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobEhCache.class);
    private static final String CACHE_PREFIX = DialobCache.class.getCanonicalName();
    private final CacheManager cacheManager;
    private final String cacheName;

    private Cache<String, DialobCache.CacheEntry> getCache() {
        return this.cacheManager.getCache(this.cacheName, String.class, DialobCache.CacheEntry.class);
    }

    @Override
    public Optional<DialobProgram> getProgram(DialobStore.StoreEntity src) {
        String id = this.toCacheId(src);
        Cache<String, DialobCache.CacheEntry> cache = this.getCache();
        Optional<DialobProgram> result = Optional.ofNullable((DialobCache.CacheEntry)cache.get((Object)id)).map(e -> e.getProgram().orElse(null));
        LOGGER.debug("Dialob, caching, program resolved: " + result.isPresent() + ", id: " + id);
        return result;
    }

    @Override
    public Optional<DialobDocument> getAst(DialobStore.StoreEntity src) {
        String id = this.toCacheId(src);
        LOGGER.debug("Dialob, caching, document resolved: " + id);
        Cache<String, DialobCache.CacheEntry> cache = this.getCache();
        Optional<DialobDocument> result = Optional.ofNullable((DialobCache.CacheEntry)cache.get((Object)id)).map(e -> e.getAst());
        return result;
    }

    @Override
    public DialobProgram setProgram(DialobProgram program, DialobStore.StoreEntity src) {
        String id = this.toCacheId(src);
        LOGGER.debug("Dialob, caching a program, id: " + id);
        Cache<String, DialobCache.CacheEntry> cache = this.getCache();
        DialobCache.CacheEntry previous = (DialobCache.CacheEntry)cache.get((Object)id);
        ImmutableCacheEntry entry = ImmutableCacheEntry.builder().from(previous).program(program).build();
        cache.put((Object)id, (Object)entry);
        return program;
    }

    @Override
    public DialobDocument setAst(DialobDocument ast, DialobStore.StoreEntity src) {
        String id = this.toCacheId(src);
        LOGGER.debug("Dialob, caching a document, id: " + id);
        ImmutableCacheEntry entry = ImmutableCacheEntry.builder().id(id).rev(ast.getVersion()).source(src).ast(ast).build();
        Cache<String, DialobCache.CacheEntry> cache = this.getCache();
        cache.put((Object)id, (Object)entry);
        return ast;
    }

    private String toCacheId(DialobStore.StoreEntity src) {
        return src.getId() + "/" + src.getVersion();
    }

    @Override
    public DialobEhCache withName(String name) {
        String cacheName = DialobEhCache.createName(name);
        int cacheHeap = 500;
        CacheManager cacheManager = CacheManagerBuilder.newCacheManagerBuilder().withCache(cacheName, (org.ehcache.config.Builder)CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, DialobCache.CacheEntry.class, (org.ehcache.config.Builder)ResourcePoolsBuilder.heap((long)500L))).build();
        cacheManager.init();
        return new DialobEhCache(cacheManager, cacheName);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static String createName(String name) {
        return CACHE_PREFIX + "-" + name;
    }

    @Override
    public void flush(String id) {
        Cache<String, DialobCache.CacheEntry> cache = this.getCache();
        DialobCache.CacheEntry entity = (DialobCache.CacheEntry)cache.get((Object)id);
        if (entity == null) {
            return;
        }
        ArrayList<String> flush = new ArrayList<String>();
        flush.add(id);
        cache.forEach(e -> {
            if (((String)e.getKey()).startsWith(id + "/")) {
                flush.add((String)e.getKey());
                return;
            }
            DialobDocument ast = ((DialobCache.CacheEntry)e.getValue()).getAst();
            if (ast.getId().equals(id) || ast.getName().equals(id)) {
                flush.add((String)e.getKey());
            }
        });
        flush.forEach(flushId -> cache.remove(flushId));
    }

    public DialobEhCache(CacheManager cacheManager, String cacheName) {
        this.cacheManager = cacheManager;
        this.cacheName = cacheName;
    }

    public static class Builder {
        public DialobEhCache build(String name) {
            String cacheName = DialobEhCache.createName(name);
            int cacheHeap = 10000;
            CacheManager cacheManager = CacheManagerBuilder.newCacheManagerBuilder().withCache(cacheName, (org.ehcache.config.Builder)CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, DialobCache.CacheEntry.class, (org.ehcache.config.Builder)ResourcePoolsBuilder.heap((long)10000L))).build();
            cacheManager.init();
            return new DialobEhCache(cacheManager, cacheName);
        }
    }
}

