/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi;

import io.dialob.api.form.Form;
import io.dialob.api.form.FormPutResponse;
import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobComposer;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.ImmutableComposerReleaseState;
import io.dialob.client.api.ImmutableComposerState;
import io.dialob.client.api.ImmutableUpdateStoreEntity;
import io.dialob.client.spi.composer.ComposerEntityMapper;
import io.dialob.client.spi.composer.CopyAsEntityVisitor;
import io.dialob.client.spi.composer.CreateFormDocumentVisitor;
import io.dialob.client.spi.composer.CreateReleaseVisitor;
import io.dialob.client.spi.composer.DeleteEntityVisitor;
import io.dialob.client.spi.composer.GetComposerDocumentState;
import io.dialob.client.spi.composer.ImportReleaseVisitor;
import io.dialob.client.spi.support.DialobAssert;
import io.smallrye.mutiny.Uni;
import java.util.List;

public class DialobComposerImpl
implements DialobComposer {
    private final DialobClient client;

    @Override
    public Uni<DialobComposer.ComposerState> get() {
        return this.client.store().query().get().onItem().transform(this::composerState);
    }

    @Override
    public Uni<DialobComposer.ComposerDocumentState> get(String idOrName) {
        return this.get(idOrName, null);
    }

    @Override
    public Uni<DialobComposer.ComposerDocumentState> get(String idOrName, String version) {
        return this.client.store().query().get().onItem().transform(this::composerState).onItem().transform(state -> new GetComposerDocumentState((DialobComposer.ComposerState)state, idOrName, version).get());
    }

    @Override
    public Uni<DialobComposer.ComposerDocumentState> create(DialobDocument.FormDocument asset) {
        return this.client.store().query().get().onItem().transform(this::composerState).onItem().transformToUni(state -> this.client.store().batch(new CreateFormDocumentVisitor((DialobComposer.ComposerState)state, asset, this.client).visit())).onItem().transform(savedEntity -> this.documentState((List<DialobStore.StoreEntity>)savedEntity));
    }

    @Override
    public Uni<DialobComposer.ComposerReleaseState> create(DialobComposer.CreateComposerRelease asset) {
        return this.client.store().query().get().onItem().transform(this::composerState).onItem().transform(state -> new CreateReleaseVisitor(this.client.getConfig(), (DialobComposer.ComposerState)state).visit(asset)).onItem().transformToUni(release -> this.client.store().create(release.getStoreEntity()).onItem().transform(saved -> ImmutableComposerReleaseState.builder().from(release.getReleaseState()).id(saved.getId()).build()));
    }

    @Override
    public Uni<DialobComposer.ComposerDocumentState> update(DialobDocument.FormDocument asset) {
        DialobAssert.notNull(asset, () -> "asset can't be null!");
        DialobAssert.notNull(asset.getData().getId(), () -> "asset.value.id can't be null!");
        DialobAssert.notNull(asset.getData().getRev(), () -> "asset.value.rev can't be null!");
        Form doc = asset.getData();
        ImmutableUpdateStoreEntity update = ImmutableUpdateStoreEntity.builder().id(doc.getId()).version(doc.getRev()).body(this.client.getConfig().getMapper().toStoreBody(asset)).bodyType(DialobDocument.DocumentType.FORM).build();
        return this.client.store().update(update).onItem().transformToUni(updated -> {
            this.client.getConfig().getCache().flush(updated.getId());
            return this.get(updated.getId());
        });
    }

    @Override
    public Uni<DialobComposer.ComposerDocumentState> update(DialobComposer.UpdateFormRevisionEntry asset) {
        return null;
    }

    @Override
    public Uni<DialobComposer.ComposerState> delete(String id, String version) {
        DialobAssert.notNull(id, () -> "id can't be null!");
        DialobAssert.notNull(version, () -> "version can't be null!");
        return this.client.store().query().get().onItem().transform(this::composerState).onItem().transform(state -> new DeleteEntityVisitor((DialobComposer.ComposerState)state, id, version).visit()).onItem().transformToUni(commands -> this.client.store().batch((List<DialobStore.StoreCommand>)commands)).onItem().transformToUni(deleted -> {
            for (DialobStore.StoreEntity entity : deleted) {
                this.client.getConfig().getCache().flush(entity.getId());
            }
            return this.client.store().query().get().onItem().transform(this::composerState);
        });
    }

    @Override
    public Uni<DialobComposer.ComposerDocumentState> copyAs(String id, String copyToName) {
        DialobAssert.notNull(id, () -> "id can't be null!");
        DialobAssert.notNull(copyToName, () -> "copyToName can't be null!");
        return this.client.store().query().get().onItem().transform(this::composerState).onItem().transform(state -> new CopyAsEntityVisitor((DialobComposer.ComposerState)state, id, this.client, copyToName).visit()).onItem().transformToUni(newEntity -> this.client.store().batch((List<DialobStore.StoreCommand>)newEntity)).onItem().transform(this::documentState);
    }

    @Override
    public Uni<DialobComposer.ComposerState> importRelease(DialobDocument.FormReleaseDocument asset) {
        DialobAssert.notNull(asset, () -> "asset can't be null!");
        return this.client.store().query().get().onItem().transform(this::composerState).onItem().transform(state -> new ImportReleaseVisitor((DialobComposer.ComposerState)state, asset, this.client).visit()).onItem().transformToUni(newEntity -> this.client.store().batch((List<DialobStore.StoreCommand>)newEntity)).onItem().transformToUni(savedEntity -> this.client.store().query().get().onItem().transform(this::composerState));
    }

    @Override
    public Uni<FormPutResponse> validate(DialobDocument.FormDocument asset) {
        return null;
    }

    @Override
    public Uni<DialobDocument.FormDocument> apply(DialobComposer.FormCommands asset) {
        return null;
    }

    private DialobComposer.ComposerDocumentState documentState(DialobStore.StoreEntity newEntity) {
        return null;
    }

    private DialobComposer.ComposerDocumentState documentState(List<DialobStore.StoreEntity> newEntity) {
        return null;
    }

    private DialobComposer.ComposerState composerState(DialobStore.StoreState source) {
        return DialobComposerImpl.composerState(this.client, source);
    }

    public static DialobComposer.ComposerState composerState(DialobClient client, DialobStore.StoreState source) {
        DialobClient.ProgramEnvir envir = ComposerEntityMapper.toEnvir(client.envir(), source).build();
        ImmutableComposerState.Builder builder = ImmutableComposerState.builder();
        envir.getValues().values().forEach(v -> ComposerEntityMapper.toComposer(builder, v));
        ImmutableComposerState result = builder.build();
        return result;
    }

    public DialobComposerImpl(DialobClient client) {
        this.client = client;
    }
}

