/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.dialob.client.api.DialobCache;
import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobClientConfig;
import io.dialob.client.api.DialobErrorHandler;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.ImmutableDialobClientConfig;
import io.dialob.client.spi.DialobClientEnvirBuilder;
import io.dialob.client.spi.DialobEhCache;
import io.dialob.client.spi.DialobErrorHandlerImpl;
import io.dialob.client.spi.DialobMemoryStore;
import io.dialob.client.spi.DialobProgramEnvirFactory;
import io.dialob.client.spi.DialobRepoBuilderImpl;
import io.dialob.client.spi.DialobTypesMapperImpl;
import io.dialob.client.spi.event.QuestionnaireEventPublisher;
import io.dialob.client.spi.executor.QuestionnaireExecutorBuilderImpl;
import io.dialob.client.spi.function.AsyncFunctionInvoker;
import io.dialob.client.spi.program.ProgramBuilderImpl;
import io.dialob.client.spi.support.DialobAssert;
import io.dialob.compiler.DialobProgramFromFormCompiler;
import io.dialob.compiler.DialobSessionUpdateHook;
import io.dialob.program.DialobSessionEvalContextFactory;
import io.dialob.rule.parser.function.FunctionRegistry;
import java.time.Clock;
import java.util.HashMap;
import javax.annotation.Nullable;

public class DialobClientImpl
implements DialobClient {
    private final DialobClientConfig config;

    @Override
    public DialobClient.ProgramBuilder program() {
        return new ProgramBuilderImpl(this.config.getCompiler());
    }

    @Override
    public DialobClient.QuestionnaireExecutorBuilder executor(DialobClient.ProgramEnvir envir) {
        return new QuestionnaireExecutorBuilderImpl(envir, this.config);
    }

    @Override
    public DialobClient.EnvirBuilder envir() {
        return new DialobClientEnvirBuilder(new DialobProgramEnvirFactory(this.config));
    }

    @Override
    public DialobClientConfig getConfig() {
        return this.config;
    }

    @Override
    public DialobStore store() {
        return this.config.getStore();
    }

    @Override
    public DialobClient.RepoBuilder repo() {
        return new DialobRepoBuilderImpl(this.config);
    }

    public static Builder builder() {
        return new Builder();
    }

    public DialobClientImpl(DialobClientConfig config) {
        this.config = config;
    }

    public static class Builder {
        private FunctionRegistry functionRegistry;
        private AsyncFunctionInvoker asyncFunctionInvoker;
        private QuestionnaireEventPublisher eventPublisher;
        private DialobStore store;
        @Nullable
        private ObjectMapper objectMapper;
        @Nullable
        private DialobSessionUpdateHook dialobSessionUpdateHook;
        @Nullable
        private DialobCache cache;
        @Nullable
        private Clock clock;
        @Nullable
        private DialobErrorHandler errorHandler;

        public DialobClientImpl build() {
            DialobErrorHandler errorHandler;
            DialobStore store;
            ObjectMapper objectMapper;
            Clock clock;
            DialobAssert.notNull(this.functionRegistry, () -> "functionRegistry must be defined!");
            DialobAssert.notNull(this.eventPublisher, () -> "eventPublisher must be defined!");
            DialobAssert.notNull(this.asyncFunctionInvoker, () -> "asyncFunctionInvoker must be defined!");
            DialobCache cache = this.cache;
            if (cache == null) {
                cache = DialobEhCache.builder().build("inmem");
            }
            if ((clock = this.clock) == null) {
                clock = Clock.systemDefaultZone();
            }
            if ((objectMapper = this.objectMapper) == null) {
                objectMapper = new ObjectMapper().registerModules(new Module[]{new JavaTimeModule(), new Jdk8Module(), new GuavaModule()});
            }
            if ((store = this.store) == null) {
                store = new DialobMemoryStore(new HashMap<String, DialobStore.StoreEntity>());
            }
            if ((errorHandler = this.errorHandler) == null) {
                errorHandler = new DialobErrorHandlerImpl(true);
            }
            ImmutableDialobClientConfig config = ImmutableDialobClientConfig.builder().asyncFunctionInvoker(this.asyncFunctionInvoker).factory(new DialobSessionEvalContextFactory(this.functionRegistry, clock, this.dialobSessionUpdateHook)).store(store).cache(cache).errorHandler(errorHandler).eventPublisher(this.eventPublisher).mapper(new DialobTypesMapperImpl(objectMapper)).compiler(new DialobProgramFromFormCompiler(this.functionRegistry)).build();
            return new DialobClientImpl(config);
        }

        public FunctionRegistry functionRegistry() {
            return this.functionRegistry;
        }

        public AsyncFunctionInvoker asyncFunctionInvoker() {
            return this.asyncFunctionInvoker;
        }

        public QuestionnaireEventPublisher eventPublisher() {
            return this.eventPublisher;
        }

        public DialobStore store() {
            return this.store;
        }

        @Nullable
        public ObjectMapper objectMapper() {
            return this.objectMapper;
        }

        @Nullable
        public DialobSessionUpdateHook dialobSessionUpdateHook() {
            return this.dialobSessionUpdateHook;
        }

        @Nullable
        public DialobCache cache() {
            return this.cache;
        }

        @Nullable
        public Clock clock() {
            return this.clock;
        }

        @Nullable
        public DialobErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Builder functionRegistry(FunctionRegistry functionRegistry) {
            this.functionRegistry = functionRegistry;
            return this;
        }

        public Builder asyncFunctionInvoker(AsyncFunctionInvoker asyncFunctionInvoker) {
            this.asyncFunctionInvoker = asyncFunctionInvoker;
            return this;
        }

        public Builder eventPublisher(QuestionnaireEventPublisher eventPublisher) {
            this.eventPublisher = eventPublisher;
            return this;
        }

        public Builder store(DialobStore store) {
            this.store = store;
            return this;
        }

        public Builder objectMapper(@Nullable ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder dialobSessionUpdateHook(@Nullable DialobSessionUpdateHook dialobSessionUpdateHook) {
            this.dialobSessionUpdateHook = dialobSessionUpdateHook;
            return this;
        }

        public Builder cache(@Nullable DialobCache cache) {
            this.cache = cache;
            return this;
        }

        public Builder clock(@Nullable Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder errorHandler(@Nullable DialobErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            FunctionRegistry this$functionRegistry = this.functionRegistry();
            FunctionRegistry other$functionRegistry = other.functionRegistry();
            if (this$functionRegistry == null ? other$functionRegistry != null : !this$functionRegistry.equals(other$functionRegistry)) {
                return false;
            }
            AsyncFunctionInvoker this$asyncFunctionInvoker = this.asyncFunctionInvoker();
            AsyncFunctionInvoker other$asyncFunctionInvoker = other.asyncFunctionInvoker();
            if (this$asyncFunctionInvoker == null ? other$asyncFunctionInvoker != null : !this$asyncFunctionInvoker.equals(other$asyncFunctionInvoker)) {
                return false;
            }
            QuestionnaireEventPublisher this$eventPublisher = this.eventPublisher();
            QuestionnaireEventPublisher other$eventPublisher = other.eventPublisher();
            if (this$eventPublisher == null ? other$eventPublisher != null : !this$eventPublisher.equals(other$eventPublisher)) {
                return false;
            }
            DialobStore this$store = this.store();
            DialobStore other$store = other.store();
            if (this$store == null ? other$store != null : !this$store.equals(other$store)) {
                return false;
            }
            ObjectMapper this$objectMapper = this.objectMapper();
            ObjectMapper other$objectMapper = other.objectMapper();
            if (this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper)) {
                return false;
            }
            DialobSessionUpdateHook this$dialobSessionUpdateHook = this.dialobSessionUpdateHook();
            DialobSessionUpdateHook other$dialobSessionUpdateHook = other.dialobSessionUpdateHook();
            if (this$dialobSessionUpdateHook == null ? other$dialobSessionUpdateHook != null : !this$dialobSessionUpdateHook.equals(other$dialobSessionUpdateHook)) {
                return false;
            }
            DialobCache this$cache = this.cache();
            DialobCache other$cache = other.cache();
            if (this$cache == null ? other$cache != null : !this$cache.equals(other$cache)) {
                return false;
            }
            Clock this$clock = this.clock();
            Clock other$clock = other.clock();
            if (this$clock == null ? other$clock != null : !((Object)this$clock).equals(other$clock)) {
                return false;
            }
            DialobErrorHandler this$errorHandler = this.errorHandler();
            DialobErrorHandler other$errorHandler = other.errorHandler();
            return !(this$errorHandler == null ? other$errorHandler != null : !this$errorHandler.equals(other$errorHandler));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FunctionRegistry $functionRegistry = this.functionRegistry();
            result = result * 59 + ($functionRegistry == null ? 43 : $functionRegistry.hashCode());
            AsyncFunctionInvoker $asyncFunctionInvoker = this.asyncFunctionInvoker();
            result = result * 59 + ($asyncFunctionInvoker == null ? 43 : $asyncFunctionInvoker.hashCode());
            QuestionnaireEventPublisher $eventPublisher = this.eventPublisher();
            result = result * 59 + ($eventPublisher == null ? 43 : $eventPublisher.hashCode());
            DialobStore $store = this.store();
            result = result * 59 + ($store == null ? 43 : $store.hashCode());
            ObjectMapper $objectMapper = this.objectMapper();
            result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
            DialobSessionUpdateHook $dialobSessionUpdateHook = this.dialobSessionUpdateHook();
            result = result * 59 + ($dialobSessionUpdateHook == null ? 43 : $dialobSessionUpdateHook.hashCode());
            DialobCache $cache = this.cache();
            result = result * 59 + ($cache == null ? 43 : $cache.hashCode());
            Clock $clock = this.clock();
            result = result * 59 + ($clock == null ? 43 : ((Object)$clock).hashCode());
            DialobErrorHandler $errorHandler = this.errorHandler();
            result = result * 59 + ($errorHandler == null ? 43 : $errorHandler.hashCode());
            return result;
        }

        public String toString() {
            return "DialobClientImpl.Builder(functionRegistry=" + this.functionRegistry() + ", asyncFunctionInvoker=" + this.asyncFunctionInvoker() + ", eventPublisher=" + this.eventPublisher() + ", store=" + this.store() + ", objectMapper=" + this.objectMapper() + ", dialobSessionUpdateHook=" + this.dialobSessionUpdateHook() + ", cache=" + this.cache() + ", clock=" + this.clock() + ", errorHandler=" + this.errorHandler() + ")";
        }
    }
}

