/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.spi;

import io.dialob.api.form.Form;
import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.ImmutableStoreEntity;
import io.dialob.client.spi.DialobProgramEnvirFactory;
import io.dialob.client.spi.support.DialobAssert;
import java.io.InputStream;

public class DialobClientEnvirBuilder
implements DialobClient.EnvirBuilder {
    private final DialobProgramEnvirFactory factory;
    private DialobClient.ProgramEnvir envir;

    @Override
    public DialobClient.EnvirCommandFormatBuilder addCommand() {
        final DialobClientEnvirBuilder enviBuilder = this;
        return new DialobClient.EnvirCommandFormatBuilder(){
            private String id;
            private DialobDocument.DocumentType type;
            private String commandJson;
            private DialobStore.StoreEntity entity;
            private boolean cachless;
            private String version;

            @Override
            public DialobClient.EnvirCommandFormatBuilder id(String externalId) {
                this.id = externalId;
                return this;
            }

            @Override
            public DialobClient.EnvirCommandFormatBuilder version(String version) {
                this.version = version;
                return this;
            }

            @Override
            public DialobClient.EnvirCommandFormatBuilder rev(String commandJson) {
                this.type = DialobDocument.DocumentType.FORM_REV;
                this.commandJson = commandJson;
                return this;
            }

            @Override
            public DialobClient.EnvirCommandFormatBuilder form(String commandJson) {
                this.type = DialobDocument.DocumentType.FORM;
                this.commandJson = commandJson;
                return this;
            }

            @Override
            public DialobClient.EnvirCommandFormatBuilder form(InputStream commandJson) {
                this.type = DialobDocument.DocumentType.FORM;
                this.commandJson = DialobClientEnvirBuilder.this.factory.getConfig().getMapper().toString(commandJson);
                return this;
            }

            @Override
            public DialobClient.EnvirCommandFormatBuilder rev(DialobStore.StoreEntity entity) {
                DialobAssert.isTrue(entity.getBodyType() == DialobDocument.DocumentType.FORM_REV, () -> "entity type must be FORM_REV!");
                this.type = DialobDocument.DocumentType.FORM_REV;
                this.entity = entity;
                return this;
            }

            @Override
            public DialobClient.EnvirCommandFormatBuilder form(DialobStore.StoreEntity entity) {
                DialobAssert.isTrue(entity.getBodyType() == DialobDocument.DocumentType.FORM, () -> "entity type must be FORM!");
                this.type = DialobDocument.DocumentType.FORM;
                this.entity = entity;
                return this;
            }

            @Override
            public DialobClient.EnvirCommandFormatBuilder cachless() {
                this.cachless = true;
                return this;
            }

            @Override
            public DialobClient.EnvirCommandFormatBuilder release(DialobStore.StoreEntity entity) {
                DialobAssert.isTrue(entity.getBodyType() == DialobDocument.DocumentType.RELEASE, () -> "entity type must be RELEASE!");
                this.type = DialobDocument.DocumentType.RELEASE;
                this.entity = entity;
                return this;
            }

            @Override
            public DialobClient.EnvirCommandFormatBuilder form(Form entity) {
                this.type = DialobDocument.DocumentType.FORM;
                this.id = entity.getId();
                this.version = entity.getRev();
                this.commandJson = DialobClientEnvirBuilder.this.factory.getConfig().getMapper().toJson(entity);
                return this;
            }

            @Override
            public DialobClient.EnvirBuilder build() {
                DialobAssert.notNull(this.id, () -> "id must be defined!");
                DialobAssert.notNull(this.version, () -> "version must be defined!");
                DialobAssert.isTrue(this.commandJson != null || this.entity != null, () -> "commandJson or entity must be defined!");
                DialobAssert.isTrue(this.commandJson == null || this.entity == null, () -> "commandJson and entity can't be both defined!");
                DialobClientEnvirBuilder.this.factory.add(ImmutableStoreEntity.builder().id(this.id).bodyType(this.type).version(this.version).body(this.entity == null ? this.commandJson : this.entity.getBody()).build(), this.cachless);
                return enviBuilder;
            }
        };
    }

    @Override
    public DialobClient.EnvirBuilder from(DialobClient.ProgramEnvir envir) {
        this.envir = envir;
        return this;
    }

    @Override
    public DialobClient.ProgramEnvir build() {
        return this.factory.add(this.envir).build();
    }

    @Override
    public DialobClient.EnvirBuilder from(DialobStore.StoreState envir) {
        envir.getForms().values().forEach(e -> this.factory.add((DialobStore.StoreEntity)e, false));
        return this;
    }

    public DialobClientEnvirBuilder(DialobProgramEnvirFactory factory) {
        this.factory = factory;
    }
}

