/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobStore;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobStore.UpdateStoreEntity", generator="Immutables")
@Immutable
public final class ImmutableUpdateStoreEntity
implements DialobStore.UpdateStoreEntity {
    private final DialobDocument.DocumentType bodyType;
    private final String id;
    private final String version;
    private final String body;

    private ImmutableUpdateStoreEntity(DialobDocument.DocumentType bodyType, String id, String version, String body) {
        this.bodyType = bodyType;
        this.id = id;
        this.version = version;
        this.body = body;
    }

    @Override
    @JsonProperty(value="bodyType")
    public DialobDocument.DocumentType getBodyType() {
        return this.bodyType;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    public final ImmutableUpdateStoreEntity withBodyType(DialobDocument.DocumentType value) {
        if (this.bodyType == value) {
            return this;
        }
        DialobDocument.DocumentType newValue = Objects.requireNonNull(value, "bodyType");
        if (this.bodyType.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableUpdateStoreEntity(newValue, this.id, this.version, this.body);
    }

    public final ImmutableUpdateStoreEntity withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateStoreEntity(this.bodyType, newValue, this.version, this.body);
    }

    public final ImmutableUpdateStoreEntity withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateStoreEntity(this.bodyType, this.id, newValue, this.body);
    }

    public final ImmutableUpdateStoreEntity withBody(String value) {
        String newValue = Objects.requireNonNull(value, "body");
        if (this.body.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateStoreEntity(this.bodyType, this.id, this.version, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateStoreEntity && this.equalTo((ImmutableUpdateStoreEntity)another);
    }

    private boolean equalTo(ImmutableUpdateStoreEntity another) {
        return this.bodyType.equals((Object)another.bodyType) && this.id.equals(another.id) && this.version.equals(another.version) && this.body.equals(another.body);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.bodyType.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.body.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UpdateStoreEntity").omitNullValues().add("bodyType", (Object)this.bodyType).add("id", (Object)this.id).add("version", (Object)this.version).add("body", (Object)this.body).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableUpdateStoreEntity fromJson(Json json) {
        Builder builder = ImmutableUpdateStoreEntity.builder();
        if (json.bodyType != null) {
            builder.bodyType(json.bodyType);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        if (json.body != null) {
            builder.body(json.body);
        }
        return builder.build();
    }

    public static ImmutableUpdateStoreEntity copyOf(DialobStore.UpdateStoreEntity instance) {
        if (instance instanceof ImmutableUpdateStoreEntity) {
            return (ImmutableUpdateStoreEntity)instance;
        }
        return ImmutableUpdateStoreEntity.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobStore.UpdateStoreEntity", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BODY_TYPE = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_VERSION = 4L;
        private static final long INIT_BIT_BODY = 8L;
        private long initBits = 15L;
        @Nullable
        private DialobDocument.DocumentType bodyType;
        @Nullable
        private String id;
        @Nullable
        private String version;
        @Nullable
        private String body;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobStore.UpdateStoreEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobStore.StoreCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DialobStore.StoreCommand instance;
            if (object instanceof DialobStore.UpdateStoreEntity) {
                instance = (DialobStore.UpdateStoreEntity)object;
                this.body(instance.getBody());
                this.version(instance.getVersion());
                this.id(instance.getId());
            }
            if (object instanceof DialobStore.StoreCommand) {
                instance = (DialobStore.StoreCommand)object;
                this.bodyType(instance.getBodyType());
            }
        }

        @JsonProperty(value="bodyType")
        @CanIgnoreReturnValue
        public final Builder bodyType(DialobDocument.DocumentType bodyType) {
            this.bodyType = Objects.requireNonNull(bodyType, "bodyType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="version")
        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="body")
        @CanIgnoreReturnValue
        public final Builder body(String body) {
            this.body = Objects.requireNonNull(body, "body");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableUpdateStoreEntity build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateStoreEntity(this.bodyType, this.id, this.version, this.body);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("bodyType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("body");
            }
            return "Cannot build UpdateStoreEntity, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DialobStore.UpdateStoreEntity", generator="Immutables")
    static final class Json
    implements DialobStore.UpdateStoreEntity {
        @Nullable
        DialobDocument.DocumentType bodyType;
        @Nullable
        String id;
        @Nullable
        String version;
        @Nullable
        String body;

        Json() {
        }

        @JsonProperty(value="bodyType")
        public void setBodyType(DialobDocument.DocumentType bodyType) {
            this.bodyType = bodyType;
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="version")
        public void setVersion(String version) {
            this.version = version;
        }

        @JsonProperty(value="body")
        public void setBody(String body) {
            this.body = body;
        }

        @Override
        public DialobDocument.DocumentType getBodyType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBody() {
            throw new UnsupportedOperationException();
        }
    }
}

