/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.api.DialobComposer;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobComposer.UpdateFormRevisionEntry", generator="Immutables")
@Immutable
public final class ImmutableUpdateFormRevisionEntry
implements DialobComposer.UpdateFormRevisionEntry {
    private final String id;
    private final String version;
    private final String revisionName;

    private ImmutableUpdateFormRevisionEntry(String id, String version, String revisionName) {
        this.id = id;
        this.version = version;
        this.revisionName = revisionName;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="revisionName")
    public String getRevisionName() {
        return this.revisionName;
    }

    public final ImmutableUpdateFormRevisionEntry withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateFormRevisionEntry(newValue, this.version, this.revisionName);
    }

    public final ImmutableUpdateFormRevisionEntry withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateFormRevisionEntry(this.id, newValue, this.revisionName);
    }

    public final ImmutableUpdateFormRevisionEntry withRevisionName(String value) {
        String newValue = Objects.requireNonNull(value, "revisionName");
        if (this.revisionName.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateFormRevisionEntry(this.id, this.version, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateFormRevisionEntry && this.equalTo((ImmutableUpdateFormRevisionEntry)another);
    }

    private boolean equalTo(ImmutableUpdateFormRevisionEntry another) {
        return this.id.equals(another.id) && this.version.equals(another.version) && this.revisionName.equals(another.revisionName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.revisionName.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UpdateFormRevisionEntry").omitNullValues().add("id", (Object)this.id).add("version", (Object)this.version).add("revisionName", (Object)this.revisionName).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableUpdateFormRevisionEntry fromJson(Json json) {
        Builder builder = ImmutableUpdateFormRevisionEntry.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        if (json.revisionName != null) {
            builder.revisionName(json.revisionName);
        }
        return builder.build();
    }

    public static ImmutableUpdateFormRevisionEntry copyOf(DialobComposer.UpdateFormRevisionEntry instance) {
        if (instance instanceof ImmutableUpdateFormRevisionEntry) {
            return (ImmutableUpdateFormRevisionEntry)instance;
        }
        return ImmutableUpdateFormRevisionEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobComposer.UpdateFormRevisionEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_VERSION = 2L;
        private static final long INIT_BIT_REVISION_NAME = 4L;
        private long initBits = 7L;
        @Nullable
        private String id;
        @Nullable
        private String version;
        @Nullable
        private String revisionName;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobComposer.UpdateFormRevisionEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.version(instance.getVersion());
            this.revisionName(instance.getRevisionName());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="version")
        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="revisionName")
        @CanIgnoreReturnValue
        public final Builder revisionName(String revisionName) {
            this.revisionName = Objects.requireNonNull(revisionName, "revisionName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUpdateFormRevisionEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateFormRevisionEntry(this.id, this.version, this.revisionName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("revisionName");
            }
            return "Cannot build UpdateFormRevisionEntry, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DialobComposer.UpdateFormRevisionEntry", generator="Immutables")
    static final class Json
    implements DialobComposer.UpdateFormRevisionEntry {
        @Nullable
        String id;
        @Nullable
        String version;
        @Nullable
        String revisionName;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="version")
        public void setVersion(String version) {
            this.version = version;
        }

        @JsonProperty(value="revisionName")
        public void setRevisionName(String revisionName) {
            this.revisionName = revisionName;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRevisionName() {
            throw new UnsupportedOperationException();
        }
    }
}

