/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.api.DialobStore;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobStore.StoreState", generator="Immutables")
@Immutable
public final class ImmutableStoreState
implements DialobStore.StoreState {
    private final ImmutableMap<String, DialobStore.StoreEntity> revs;
    private final ImmutableMap<String, DialobStore.StoreEntity> forms;
    private final ImmutableMap<String, DialobStore.StoreEntity> tags;

    private ImmutableStoreState(ImmutableMap<String, DialobStore.StoreEntity> revs, ImmutableMap<String, DialobStore.StoreEntity> forms, ImmutableMap<String, DialobStore.StoreEntity> tags) {
        this.revs = revs;
        this.forms = forms;
        this.tags = tags;
    }

    @JsonProperty(value="revs")
    public ImmutableMap<String, DialobStore.StoreEntity> getRevs() {
        return this.revs;
    }

    @JsonProperty(value="forms")
    public ImmutableMap<String, DialobStore.StoreEntity> getForms() {
        return this.forms;
    }

    @JsonProperty(value="tags")
    public ImmutableMap<String, DialobStore.StoreEntity> getTags() {
        return this.tags;
    }

    public final ImmutableStoreState withRevs(Map<String, ? extends DialobStore.StoreEntity> entries) {
        if (this.revs == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableStoreState((ImmutableMap<String, DialobStore.StoreEntity>)newValue, this.forms, this.tags);
    }

    public final ImmutableStoreState withForms(Map<String, ? extends DialobStore.StoreEntity> entries) {
        if (this.forms == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableStoreState(this.revs, (ImmutableMap<String, DialobStore.StoreEntity>)newValue, this.tags);
    }

    public final ImmutableStoreState withTags(Map<String, ? extends DialobStore.StoreEntity> entries) {
        if (this.tags == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableStoreState(this.revs, this.forms, (ImmutableMap<String, DialobStore.StoreEntity>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStoreState && this.equalTo((ImmutableStoreState)another);
    }

    private boolean equalTo(ImmutableStoreState another) {
        return this.revs.equals(another.revs) && this.forms.equals(another.forms) && this.tags.equals(another.tags);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.revs.hashCode();
        h += (h << 5) + this.forms.hashCode();
        h += (h << 5) + this.tags.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StoreState").omitNullValues().add("revs", this.revs).add("forms", this.forms).add("tags", this.tags).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStoreState fromJson(Json json) {
        Builder builder = ImmutableStoreState.builder();
        if (json.revs != null) {
            builder.putAllRevs(json.revs);
        }
        if (json.forms != null) {
            builder.putAllForms(json.forms);
        }
        if (json.tags != null) {
            builder.putAllTags(json.tags);
        }
        return builder.build();
    }

    public static ImmutableStoreState copyOf(DialobStore.StoreState instance) {
        if (instance instanceof ImmutableStoreState) {
            return (ImmutableStoreState)instance;
        }
        return ImmutableStoreState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobStore.StoreState", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableMap.Builder<String, DialobStore.StoreEntity> revs = ImmutableMap.builder();
        private ImmutableMap.Builder<String, DialobStore.StoreEntity> forms = ImmutableMap.builder();
        private ImmutableMap.Builder<String, DialobStore.StoreEntity> tags = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobStore.StoreState instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllRevs(instance.getRevs());
            this.putAllForms(instance.getForms());
            this.putAllTags(instance.getTags());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putRevs(String key, DialobStore.StoreEntity value) {
            this.revs.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putRevs(Map.Entry<String, ? extends DialobStore.StoreEntity> entry) {
            this.revs.put(entry);
            return this;
        }

        @JsonProperty(value="revs")
        @CanIgnoreReturnValue
        public final Builder revs(Map<String, ? extends DialobStore.StoreEntity> entries) {
            this.revs = ImmutableMap.builder();
            return this.putAllRevs(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllRevs(Map<String, ? extends DialobStore.StoreEntity> entries) {
            this.revs.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putForms(String key, DialobStore.StoreEntity value) {
            this.forms.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putForms(Map.Entry<String, ? extends DialobStore.StoreEntity> entry) {
            this.forms.put(entry);
            return this;
        }

        @JsonProperty(value="forms")
        @CanIgnoreReturnValue
        public final Builder forms(Map<String, ? extends DialobStore.StoreEntity> entries) {
            this.forms = ImmutableMap.builder();
            return this.putAllForms(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllForms(Map<String, ? extends DialobStore.StoreEntity> entries) {
            this.forms.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putTags(String key, DialobStore.StoreEntity value) {
            this.tags.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putTags(Map.Entry<String, ? extends DialobStore.StoreEntity> entry) {
            this.tags.put(entry);
            return this;
        }

        @JsonProperty(value="tags")
        @CanIgnoreReturnValue
        public final Builder tags(Map<String, ? extends DialobStore.StoreEntity> entries) {
            this.tags = ImmutableMap.builder();
            return this.putAllTags(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllTags(Map<String, ? extends DialobStore.StoreEntity> entries) {
            this.tags.putAll(entries);
            return this;
        }

        public ImmutableStoreState build() {
            return new ImmutableStoreState((ImmutableMap<String, DialobStore.StoreEntity>)this.revs.build(), (ImmutableMap<String, DialobStore.StoreEntity>)this.forms.build(), (ImmutableMap<String, DialobStore.StoreEntity>)this.tags.build());
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DialobStore.StoreState", generator="Immutables")
    static final class Json
    implements DialobStore.StoreState {
        @Nullable
        Map<String, DialobStore.StoreEntity> revs = ImmutableMap.of();
        @Nullable
        Map<String, DialobStore.StoreEntity> forms = ImmutableMap.of();
        @Nullable
        Map<String, DialobStore.StoreEntity> tags = ImmutableMap.of();

        Json() {
        }

        @JsonProperty(value="revs")
        public void setRevs(Map<String, DialobStore.StoreEntity> revs) {
            this.revs = revs;
        }

        @JsonProperty(value="forms")
        public void setForms(Map<String, DialobStore.StoreEntity> forms) {
            this.forms = forms;
        }

        @JsonProperty(value="tags")
        public void setTags(Map<String, DialobStore.StoreEntity> tags) {
            this.tags = tags;
        }

        @Override
        public Map<String, DialobStore.StoreEntity> getRevs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, DialobStore.StoreEntity> getForms() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, DialobStore.StoreEntity> getTags() {
            throw new UnsupportedOperationException();
        }
    }
}

