/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.api.DialobStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobStore.StoreExceptionMsg", generator="Immutables")
@Immutable
public final class ImmutableStoreExceptionMsg
implements DialobStore.StoreExceptionMsg {
    private final String id;
    private final String value;
    private final ImmutableList<String> args;

    private ImmutableStoreExceptionMsg(String id, String value, ImmutableList<String> args) {
        this.id = id;
        this.value = value;
        this.args = args;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="args")
    public ImmutableList<String> getArgs() {
        return this.args;
    }

    public final ImmutableStoreExceptionMsg withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableStoreExceptionMsg(newValue, this.value, this.args);
    }

    public final ImmutableStoreExceptionMsg withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableStoreExceptionMsg(this.id, newValue, this.args);
    }

    public final ImmutableStoreExceptionMsg withArgs(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableStoreExceptionMsg(this.id, this.value, (ImmutableList<String>)newValue);
    }

    public final ImmutableStoreExceptionMsg withArgs(Iterable<String> elements) {
        if (this.args == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableStoreExceptionMsg(this.id, this.value, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStoreExceptionMsg && this.equalTo((ImmutableStoreExceptionMsg)another);
    }

    private boolean equalTo(ImmutableStoreExceptionMsg another) {
        return this.id.equals(another.id) && this.value.equals(another.value) && this.args.equals(another.args);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.args.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StoreExceptionMsg").omitNullValues().add("id", (Object)this.id).add("value", (Object)this.value).add("args", this.args).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStoreExceptionMsg fromJson(Json json) {
        Builder builder = ImmutableStoreExceptionMsg.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        if (json.args != null) {
            builder.addAllArgs(json.args);
        }
        return builder.build();
    }

    public static ImmutableStoreExceptionMsg copyOf(DialobStore.StoreExceptionMsg instance) {
        if (instance instanceof ImmutableStoreExceptionMsg) {
            return (ImmutableStoreExceptionMsg)instance;
        }
        return ImmutableStoreExceptionMsg.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobStore.StoreExceptionMsg", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private String value;
        private ImmutableList.Builder<String> args = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobStore.StoreExceptionMsg instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.value(instance.getValue());
            this.addAllArgs(instance.getArgs());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArgs(String element) {
            this.args.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArgs(String ... elements) {
            this.args.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder args(Iterable<String> elements) {
            this.args = ImmutableList.builder();
            return this.addAllArgs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllArgs(Iterable<String> elements) {
            this.args.addAll(elements);
            return this;
        }

        public ImmutableStoreExceptionMsg build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStoreExceptionMsg(this.id, this.value, (ImmutableList<String>)this.args.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build StoreExceptionMsg, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DialobStore.StoreExceptionMsg", generator="Immutables")
    static final class Json
    implements DialobStore.StoreExceptionMsg {
        @Nullable
        String id;
        @Nullable
        String value;
        @Nullable
        List<String> args = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty(value="args")
        public void setArgs(List<String> args) {
            this.args = args;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getArgs() {
            throw new UnsupportedOperationException();
        }
    }
}

