/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobStore;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobClient.RevisionWrapper", generator="Immutables")
@Immutable
public final class ImmutableRevisionWrapper
implements DialobClient.RevisionWrapper {
    private final DialobStore.StoreEntity source;
    private final DialobDocument.FormRevisionDocument document;

    private ImmutableRevisionWrapper(DialobStore.StoreEntity source, DialobDocument.FormRevisionDocument document) {
        this.source = source;
        this.document = document;
    }

    @Override
    public DialobStore.StoreEntity getSource() {
        return this.source;
    }

    @Override
    public DialobDocument.FormRevisionDocument getDocument() {
        return this.document;
    }

    public final ImmutableRevisionWrapper withSource(DialobStore.StoreEntity value) {
        if (this.source == value) {
            return this;
        }
        DialobStore.StoreEntity newValue = Objects.requireNonNull(value, "source");
        return new ImmutableRevisionWrapper(newValue, this.document);
    }

    public final ImmutableRevisionWrapper withDocument(DialobDocument.FormRevisionDocument value) {
        if (this.document == value) {
            return this;
        }
        DialobDocument.FormRevisionDocument newValue = Objects.requireNonNull(value, "document");
        return new ImmutableRevisionWrapper(this.source, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRevisionWrapper && this.equalTo((ImmutableRevisionWrapper)another);
    }

    private boolean equalTo(ImmutableRevisionWrapper another) {
        return this.source.equals(another.source) && this.document.equals(another.document);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + this.document.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RevisionWrapper").omitNullValues().add("source", (Object)this.source).add("document", (Object)this.document).toString();
    }

    public static ImmutableRevisionWrapper copyOf(DialobClient.RevisionWrapper instance) {
        if (instance instanceof ImmutableRevisionWrapper) {
            return (ImmutableRevisionWrapper)instance;
        }
        return ImmutableRevisionWrapper.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobClient.RevisionWrapper", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SOURCE = 1L;
        private static final long INIT_BIT_DOCUMENT = 2L;
        private long initBits = 3L;
        @Nullable
        private DialobStore.StoreEntity source;
        @Nullable
        private DialobDocument.FormRevisionDocument document;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobClient.RevisionWrapper instance) {
            Objects.requireNonNull(instance, "instance");
            this.source(instance.getSource());
            this.document((DialobDocument.FormRevisionDocument)instance.getDocument());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder source(DialobStore.StoreEntity source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder document(DialobDocument.FormRevisionDocument document) {
            this.document = Objects.requireNonNull(document, "document");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRevisionWrapper build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRevisionWrapper(this.source, this.document);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("source");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("document");
            }
            return "Cannot build RevisionWrapper, some of required attributes are not set " + attributes;
        }
    }
}

