/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobStore;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobClient.ReleaseWrapper", generator="Immutables")
@Immutable
public final class ImmutableReleaseWrapper
implements DialobClient.ReleaseWrapper {
    private final DialobStore.StoreEntity source;
    private final DialobDocument.FormReleaseDocument document;

    private ImmutableReleaseWrapper(DialobStore.StoreEntity source, DialobDocument.FormReleaseDocument document) {
        this.source = source;
        this.document = document;
    }

    @Override
    public DialobStore.StoreEntity getSource() {
        return this.source;
    }

    @Override
    public DialobDocument.FormReleaseDocument getDocument() {
        return this.document;
    }

    public final ImmutableReleaseWrapper withSource(DialobStore.StoreEntity value) {
        if (this.source == value) {
            return this;
        }
        DialobStore.StoreEntity newValue = Objects.requireNonNull(value, "source");
        return new ImmutableReleaseWrapper(newValue, this.document);
    }

    public final ImmutableReleaseWrapper withDocument(DialobDocument.FormReleaseDocument value) {
        if (this.document == value) {
            return this;
        }
        DialobDocument.FormReleaseDocument newValue = Objects.requireNonNull(value, "document");
        return new ImmutableReleaseWrapper(this.source, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReleaseWrapper && this.equalTo((ImmutableReleaseWrapper)another);
    }

    private boolean equalTo(ImmutableReleaseWrapper another) {
        return this.source.equals(another.source) && this.document.equals(another.document);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + this.document.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ReleaseWrapper").omitNullValues().add("source", (Object)this.source).add("document", (Object)this.document).toString();
    }

    public static ImmutableReleaseWrapper copyOf(DialobClient.ReleaseWrapper instance) {
        if (instance instanceof ImmutableReleaseWrapper) {
            return (ImmutableReleaseWrapper)instance;
        }
        return ImmutableReleaseWrapper.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobClient.ReleaseWrapper", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SOURCE = 1L;
        private static final long INIT_BIT_DOCUMENT = 2L;
        private long initBits = 3L;
        @Nullable
        private DialobStore.StoreEntity source;
        @Nullable
        private DialobDocument.FormReleaseDocument document;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobClient.ReleaseWrapper instance) {
            Objects.requireNonNull(instance, "instance");
            this.source(instance.getSource());
            this.document((DialobDocument.FormReleaseDocument)instance.getDocument());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder source(DialobStore.StoreEntity source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder document(DialobDocument.FormReleaseDocument document) {
            this.document = Objects.requireNonNull(document, "document");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableReleaseWrapper build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReleaseWrapper(this.source, this.document);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("source");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("document");
            }
            return "Cannot build ReleaseWrapper, some of required attributes are not set " + attributes;
        }
    }
}

