/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobStore;
import io.dialob.program.DialobProgram;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobClient.ProgramWrapper", generator="Immutables")
@Immutable
public final class ImmutableProgramWrapper
implements DialobClient.ProgramWrapper {
    private final DialobStore.StoreEntity source;
    private final DialobDocument.FormDocument document;
    private final String id;
    private final DialobClient.ProgramStatus status;
    private final ImmutableList<DialobClient.ProgramMessage> errors;
    @Nullable
    private final DialobProgram program;

    private ImmutableProgramWrapper(DialobStore.StoreEntity source, DialobDocument.FormDocument document, String id, DialobClient.ProgramStatus status, ImmutableList<DialobClient.ProgramMessage> errors, @Nullable DialobProgram program) {
        this.source = source;
        this.document = document;
        this.id = id;
        this.status = status;
        this.errors = errors;
        this.program = program;
    }

    @Override
    public DialobStore.StoreEntity getSource() {
        return this.source;
    }

    @Override
    public DialobDocument.FormDocument getDocument() {
        return this.document;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public DialobClient.ProgramStatus getStatus() {
        return this.status;
    }

    public ImmutableList<DialobClient.ProgramMessage> getErrors() {
        return this.errors;
    }

    @Override
    public Optional<DialobProgram> getProgram() {
        return Optional.ofNullable(this.program);
    }

    public final ImmutableProgramWrapper withSource(DialobStore.StoreEntity value) {
        if (this.source == value) {
            return this;
        }
        DialobStore.StoreEntity newValue = Objects.requireNonNull(value, "source");
        return new ImmutableProgramWrapper(newValue, this.document, this.id, this.status, this.errors, this.program);
    }

    public final ImmutableProgramWrapper withDocument(DialobDocument.FormDocument value) {
        if (this.document == value) {
            return this;
        }
        DialobDocument.FormDocument newValue = Objects.requireNonNull(value, "document");
        return new ImmutableProgramWrapper(this.source, newValue, this.id, this.status, this.errors, this.program);
    }

    public final ImmutableProgramWrapper withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableProgramWrapper(this.source, this.document, newValue, this.status, this.errors, this.program);
    }

    public final ImmutableProgramWrapper withStatus(DialobClient.ProgramStatus value) {
        if (this.status == value) {
            return this;
        }
        DialobClient.ProgramStatus newValue = Objects.requireNonNull(value, "status");
        if (this.status.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableProgramWrapper(this.source, this.document, this.id, newValue, this.errors, this.program);
    }

    public final ImmutableProgramWrapper withErrors(DialobClient.ProgramMessage ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableProgramWrapper(this.source, this.document, this.id, this.status, (ImmutableList<DialobClient.ProgramMessage>)newValue, this.program);
    }

    public final ImmutableProgramWrapper withErrors(Iterable<? extends DialobClient.ProgramMessage> elements) {
        if (this.errors == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableProgramWrapper(this.source, this.document, this.id, this.status, (ImmutableList<DialobClient.ProgramMessage>)newValue, this.program);
    }

    public final ImmutableProgramWrapper withProgram(DialobProgram value) {
        DialobProgram newValue = Objects.requireNonNull(value, "program");
        if (this.program == newValue) {
            return this;
        }
        return new ImmutableProgramWrapper(this.source, this.document, this.id, this.status, this.errors, newValue);
    }

    public final ImmutableProgramWrapper withProgram(Optional<? extends DialobProgram> optional) {
        DialobProgram value = optional.orElse(null);
        if (this.program == value) {
            return this;
        }
        return new ImmutableProgramWrapper(this.source, this.document, this.id, this.status, this.errors, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProgramWrapper && this.equalTo((ImmutableProgramWrapper)another);
    }

    private boolean equalTo(ImmutableProgramWrapper another) {
        return this.source.equals(another.source) && this.document.equals(another.document) && this.id.equals(another.id) && this.status.equals((Object)another.status) && this.errors.equals(another.errors) && Objects.equals(this.program, another.program);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + this.document.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + this.errors.hashCode();
        h += (h << 5) + Objects.hashCode(this.program);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ProgramWrapper").omitNullValues().add("source", (Object)this.source).add("document", (Object)this.document).add("id", (Object)this.id).add("status", (Object)this.status).add("errors", this.errors).add("program", (Object)this.program).toString();
    }

    public static ImmutableProgramWrapper copyOf(DialobClient.ProgramWrapper instance) {
        if (instance instanceof ImmutableProgramWrapper) {
            return (ImmutableProgramWrapper)instance;
        }
        return ImmutableProgramWrapper.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobClient.ProgramWrapper", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SOURCE = 1L;
        private static final long INIT_BIT_DOCUMENT = 2L;
        private static final long INIT_BIT_ID = 4L;
        private static final long INIT_BIT_STATUS = 8L;
        private long initBits = 15L;
        @Nullable
        private DialobStore.StoreEntity source;
        @Nullable
        private DialobDocument.FormDocument document;
        @Nullable
        private String id;
        @Nullable
        private DialobClient.ProgramStatus status;
        private ImmutableList.Builder<DialobClient.ProgramMessage> errors = ImmutableList.builder();
        @Nullable
        private DialobProgram program;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobClient.ProgramWrapper instance) {
            Objects.requireNonNull(instance, "instance");
            this.source(instance.getSource());
            this.document((DialobDocument.FormDocument)instance.getDocument());
            this.id(instance.getId());
            this.status(instance.getStatus());
            this.addAllErrors(instance.getErrors());
            Optional<DialobProgram> programOptional = instance.getProgram();
            if (programOptional.isPresent()) {
                this.program(programOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder source(DialobStore.StoreEntity source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder document(DialobDocument.FormDocument document) {
            this.document = Objects.requireNonNull(document, "document");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder status(DialobClient.ProgramStatus status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addErrors(DialobClient.ProgramMessage element) {
            this.errors.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addErrors(DialobClient.ProgramMessage ... elements) {
            this.errors.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder errors(Iterable<? extends DialobClient.ProgramMessage> elements) {
            this.errors = ImmutableList.builder();
            return this.addAllErrors(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllErrors(Iterable<? extends DialobClient.ProgramMessage> elements) {
            this.errors.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder program(DialobProgram program) {
            this.program = Objects.requireNonNull(program, "program");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder program(Optional<? extends DialobProgram> program) {
            this.program = program.orElse(null);
            return this;
        }

        public ImmutableProgramWrapper build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProgramWrapper(this.source, this.document, this.id, this.status, (ImmutableList<DialobClient.ProgramMessage>)this.errors.build(), this.program);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("source");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("document");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("status");
            }
            return "Cannot build ProgramWrapper, some of required attributes are not set " + attributes;
        }
    }
}

