/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.api.form.FormValidationError;
import io.dialob.client.api.DialobClient;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobClient.ProgramMessage", generator="Immutables")
@Immutable
public final class ImmutableProgramMessage
implements DialobClient.ProgramMessage {
    private final String id;
    @Nullable
    private final String msg;
    @Nullable
    private final FormValidationError src;
    @Nullable
    private final Exception exception;

    private ImmutableProgramMessage(String id, @Nullable String msg, @Nullable FormValidationError src, @Nullable Exception exception) {
        this.id = id;
        this.msg = msg;
        this.src = src;
        this.exception = exception;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getMsg() {
        return this.msg;
    }

    @Override
    @Nullable
    public FormValidationError getSrc() {
        return this.src;
    }

    @Override
    @Nullable
    public Exception getException() {
        return this.exception;
    }

    public final ImmutableProgramMessage withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableProgramMessage(newValue, this.msg, this.src, this.exception);
    }

    public final ImmutableProgramMessage withMsg(@Nullable String value) {
        if (Objects.equals(this.msg, value)) {
            return this;
        }
        return new ImmutableProgramMessage(this.id, value, this.src, this.exception);
    }

    public final ImmutableProgramMessage withSrc(@Nullable FormValidationError value) {
        if (this.src == value) {
            return this;
        }
        return new ImmutableProgramMessage(this.id, this.msg, value, this.exception);
    }

    public final ImmutableProgramMessage withException(@Nullable Exception value) {
        if (this.exception == value) {
            return this;
        }
        return new ImmutableProgramMessage(this.id, this.msg, this.src, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProgramMessage && this.equalTo((ImmutableProgramMessage)another);
    }

    private boolean equalTo(ImmutableProgramMessage another) {
        return this.id.equals(another.id) && Objects.equals(this.msg, another.msg) && Objects.equals(this.src, another.src) && Objects.equals(this.exception, another.exception);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.msg);
        h += (h << 5) + Objects.hashCode(this.src);
        h += (h << 5) + Objects.hashCode(this.exception);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ProgramMessage").omitNullValues().add("id", (Object)this.id).add("msg", (Object)this.msg).add("src", (Object)this.src).add("exception", (Object)this.exception).toString();
    }

    public static ImmutableProgramMessage copyOf(DialobClient.ProgramMessage instance) {
        if (instance instanceof ImmutableProgramMessage) {
            return (ImmutableProgramMessage)instance;
        }
        return ImmutableProgramMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobClient.ProgramMessage", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        @Nullable
        private String msg;
        @Nullable
        private FormValidationError src;
        @Nullable
        private Exception exception;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobClient.ProgramMessage instance) {
            Exception exceptionValue;
            FormValidationError srcValue;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            String msgValue = instance.getMsg();
            if (msgValue != null) {
                this.msg(msgValue);
            }
            if ((srcValue = instance.getSrc()) != null) {
                this.src(srcValue);
            }
            if ((exceptionValue = instance.getException()) != null) {
                this.exception(exceptionValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder msg(@Nullable String msg) {
            this.msg = msg;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder src(@Nullable FormValidationError src) {
            this.src = src;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder exception(@Nullable Exception exception) {
            this.exception = exception;
            return this;
        }

        public ImmutableProgramMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProgramMessage(this.id, this.msg, this.src, this.exception);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build ProgramMessage, some of required attributes are not set " + attributes;
        }
    }
}

