/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.api.DialobDocument;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobDocument.FormRevisionEntryDocument", generator="Immutables")
@Immutable
public final class ImmutableFormRevisionEntryDocument
implements DialobDocument.FormRevisionEntryDocument {
    @Nullable
    private final String id;
    private final String revisionName;
    private final String formId;
    private final LocalDateTime created;
    private final LocalDateTime updated;
    @Nullable
    private final String description;

    private ImmutableFormRevisionEntryDocument(@Nullable String id, String revisionName, String formId, LocalDateTime created, LocalDateTime updated, @Nullable String description) {
        this.id = id;
        this.revisionName = revisionName;
        this.formId = formId;
        this.created = created;
        this.updated = updated;
        this.description = description;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="revisionName")
    public String getRevisionName() {
        return this.revisionName;
    }

    @Override
    @JsonProperty(value="formId")
    public String getFormId() {
        return this.formId;
    }

    @Override
    @JsonProperty(value="created")
    public LocalDateTime getCreated() {
        return this.created;
    }

    @Override
    @JsonProperty(value="updated")
    public LocalDateTime getUpdated() {
        return this.updated;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public final ImmutableFormRevisionEntryDocument withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableFormRevisionEntryDocument(value, this.revisionName, this.formId, this.created, this.updated, this.description);
    }

    public final ImmutableFormRevisionEntryDocument withRevisionName(String value) {
        String newValue = Objects.requireNonNull(value, "revisionName");
        if (this.revisionName.equals(newValue)) {
            return this;
        }
        return new ImmutableFormRevisionEntryDocument(this.id, newValue, this.formId, this.created, this.updated, this.description);
    }

    public final ImmutableFormRevisionEntryDocument withFormId(String value) {
        String newValue = Objects.requireNonNull(value, "formId");
        if (this.formId.equals(newValue)) {
            return this;
        }
        return new ImmutableFormRevisionEntryDocument(this.id, this.revisionName, newValue, this.created, this.updated, this.description);
    }

    public final ImmutableFormRevisionEntryDocument withCreated(LocalDateTime value) {
        if (this.created == value) {
            return this;
        }
        LocalDateTime newValue = Objects.requireNonNull(value, "created");
        return new ImmutableFormRevisionEntryDocument(this.id, this.revisionName, this.formId, newValue, this.updated, this.description);
    }

    public final ImmutableFormRevisionEntryDocument withUpdated(LocalDateTime value) {
        if (this.updated == value) {
            return this;
        }
        LocalDateTime newValue = Objects.requireNonNull(value, "updated");
        return new ImmutableFormRevisionEntryDocument(this.id, this.revisionName, this.formId, this.created, newValue, this.description);
    }

    public final ImmutableFormRevisionEntryDocument withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableFormRevisionEntryDocument(this.id, this.revisionName, this.formId, this.created, this.updated, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFormRevisionEntryDocument && this.equalTo((ImmutableFormRevisionEntryDocument)another);
    }

    private boolean equalTo(ImmutableFormRevisionEntryDocument another) {
        return Objects.equals(this.id, another.id) && this.revisionName.equals(another.revisionName) && this.formId.equals(another.formId) && this.created.equals(another.created) && this.updated.equals(another.updated) && Objects.equals(this.description, another.description);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.revisionName.hashCode();
        h += (h << 5) + this.formId.hashCode();
        h += (h << 5) + this.created.hashCode();
        h += (h << 5) + this.updated.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FormRevisionEntryDocument").omitNullValues().add("id", (Object)this.id).add("revisionName", (Object)this.revisionName).add("formId", (Object)this.formId).add("created", (Object)this.created).add("updated", (Object)this.updated).add("description", (Object)this.description).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFormRevisionEntryDocument fromJson(Json json) {
        Builder builder = ImmutableFormRevisionEntryDocument.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.revisionName != null) {
            builder.revisionName(json.revisionName);
        }
        if (json.formId != null) {
            builder.formId(json.formId);
        }
        if (json.created != null) {
            builder.created(json.created);
        }
        if (json.updated != null) {
            builder.updated(json.updated);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        return builder.build();
    }

    public static ImmutableFormRevisionEntryDocument copyOf(DialobDocument.FormRevisionEntryDocument instance) {
        if (instance instanceof ImmutableFormRevisionEntryDocument) {
            return (ImmutableFormRevisionEntryDocument)instance;
        }
        return ImmutableFormRevisionEntryDocument.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobDocument.FormRevisionEntryDocument", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REVISION_NAME = 1L;
        private static final long INIT_BIT_FORM_ID = 2L;
        private static final long INIT_BIT_CREATED = 4L;
        private static final long INIT_BIT_UPDATED = 8L;
        private long initBits = 15L;
        @Nullable
        private String id;
        @Nullable
        private String revisionName;
        @Nullable
        private String formId;
        @Nullable
        private LocalDateTime created;
        @Nullable
        private LocalDateTime updated;
        @Nullable
        private String description;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobDocument.FormRevisionEntryDocument instance) {
            Objects.requireNonNull(instance, "instance");
            String idValue = instance.getId();
            if (idValue != null) {
                this.id(idValue);
            }
            this.revisionName(instance.getRevisionName());
            this.formId(instance.getFormId());
            this.created(instance.getCreated());
            this.updated(instance.getUpdated());
            String descriptionValue = instance.getDescription();
            if (descriptionValue != null) {
                this.description(descriptionValue);
            }
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="revisionName")
        @CanIgnoreReturnValue
        public final Builder revisionName(String revisionName) {
            this.revisionName = Objects.requireNonNull(revisionName, "revisionName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="formId")
        @CanIgnoreReturnValue
        public final Builder formId(String formId) {
            this.formId = Objects.requireNonNull(formId, "formId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="created")
        @CanIgnoreReturnValue
        public final Builder created(LocalDateTime created) {
            this.created = Objects.requireNonNull(created, "created");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="updated")
        @CanIgnoreReturnValue
        public final Builder updated(LocalDateTime updated) {
            this.updated = Objects.requireNonNull(updated, "updated");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public ImmutableFormRevisionEntryDocument build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFormRevisionEntryDocument(this.id, this.revisionName, this.formId, this.created, this.updated, this.description);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("revisionName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("formId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("created");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("updated");
            }
            return "Cannot build FormRevisionEntryDocument, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DialobDocument.FormRevisionEntryDocument", generator="Immutables")
    static final class Json
    implements DialobDocument.FormRevisionEntryDocument {
        @Nullable
        String id;
        @Nullable
        String revisionName;
        @Nullable
        String formId;
        @Nullable
        LocalDateTime created;
        @Nullable
        LocalDateTime updated;
        @Nullable
        String description;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="revisionName")
        public void setRevisionName(String revisionName) {
            this.revisionName = revisionName;
        }

        @JsonProperty(value="formId")
        public void setFormId(String formId) {
            this.formId = formId;
        }

        @JsonProperty(value="created")
        public void setCreated(LocalDateTime created) {
            this.created = created;
        }

        @JsonProperty(value="updated")
        public void setUpdated(LocalDateTime updated) {
            this.updated = updated;
        }

        @JsonProperty(value="description")
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRevisionName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getFormId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LocalDateTime getCreated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LocalDateTime getUpdated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }
    }
}

