/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.api.DialobDocument;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobDocument.FormRevisionDocument", generator="Immutables")
@Immutable
public final class ImmutableFormRevisionDocument
implements DialobDocument.FormRevisionDocument {
    @Nullable
    private final String id;
    @Nullable
    private final String version;
    @Nullable
    private final String description;
    private final String name;
    private final LocalDateTime created;
    private final String head;
    private final LocalDateTime updated;
    private final ImmutableList<DialobDocument.FormRevisionEntryDocument> entries;
    private final DialobDocument.DocumentType type;

    private ImmutableFormRevisionDocument(Builder builder) {
        this.id = builder.id;
        this.version = builder.version;
        this.description = builder.description;
        this.name = builder.name;
        this.created = builder.created;
        this.head = builder.head;
        this.updated = builder.updated;
        this.entries = builder.entries.build();
        this.type = builder.type != null ? builder.type : Objects.requireNonNull(DialobDocument.FormRevisionDocument.super.getType(), "type");
    }

    private ImmutableFormRevisionDocument(@Nullable String id, @Nullable String version, @Nullable String description, String name, LocalDateTime created, String head, LocalDateTime updated, ImmutableList<DialobDocument.FormRevisionEntryDocument> entries, DialobDocument.DocumentType type) {
        this.id = id;
        this.version = version;
        this.description = description;
        this.name = name;
        this.created = created;
        this.head = head;
        this.updated = updated;
        this.entries = entries;
        this.type = type;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="version")
    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="created")
    public LocalDateTime getCreated() {
        return this.created;
    }

    @Override
    @JsonProperty(value="head")
    public String getHead() {
        return this.head;
    }

    @Override
    @JsonProperty(value="updated")
    public LocalDateTime getUpdated() {
        return this.updated;
    }

    @JsonProperty(value="entries")
    public ImmutableList<DialobDocument.FormRevisionEntryDocument> getEntries() {
        return this.entries;
    }

    @Override
    @JsonProperty(value="type")
    public DialobDocument.DocumentType getType() {
        return this.type;
    }

    public final ImmutableFormRevisionDocument withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableFormRevisionDocument(value, this.version, this.description, this.name, this.created, this.head, this.updated, this.entries, this.type);
    }

    public final ImmutableFormRevisionDocument withVersion(@Nullable String value) {
        if (Objects.equals(this.version, value)) {
            return this;
        }
        return new ImmutableFormRevisionDocument(this.id, value, this.description, this.name, this.created, this.head, this.updated, this.entries, this.type);
    }

    public final ImmutableFormRevisionDocument withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableFormRevisionDocument(this.id, this.version, value, this.name, this.created, this.head, this.updated, this.entries, this.type);
    }

    public final ImmutableFormRevisionDocument withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableFormRevisionDocument(this.id, this.version, this.description, newValue, this.created, this.head, this.updated, this.entries, this.type);
    }

    public final ImmutableFormRevisionDocument withCreated(LocalDateTime value) {
        if (this.created == value) {
            return this;
        }
        LocalDateTime newValue = Objects.requireNonNull(value, "created");
        return new ImmutableFormRevisionDocument(this.id, this.version, this.description, this.name, newValue, this.head, this.updated, this.entries, this.type);
    }

    public final ImmutableFormRevisionDocument withHead(String value) {
        String newValue = Objects.requireNonNull(value, "head");
        if (this.head.equals(newValue)) {
            return this;
        }
        return new ImmutableFormRevisionDocument(this.id, this.version, this.description, this.name, this.created, newValue, this.updated, this.entries, this.type);
    }

    public final ImmutableFormRevisionDocument withUpdated(LocalDateTime value) {
        if (this.updated == value) {
            return this;
        }
        LocalDateTime newValue = Objects.requireNonNull(value, "updated");
        return new ImmutableFormRevisionDocument(this.id, this.version, this.description, this.name, this.created, this.head, newValue, this.entries, this.type);
    }

    public final ImmutableFormRevisionDocument withEntries(DialobDocument.FormRevisionEntryDocument ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableFormRevisionDocument(this.id, this.version, this.description, this.name, this.created, this.head, this.updated, (ImmutableList<DialobDocument.FormRevisionEntryDocument>)newValue, this.type);
    }

    public final ImmutableFormRevisionDocument withEntries(Iterable<? extends DialobDocument.FormRevisionEntryDocument> elements) {
        if (this.entries == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableFormRevisionDocument(this.id, this.version, this.description, this.name, this.created, this.head, this.updated, (ImmutableList<DialobDocument.FormRevisionEntryDocument>)newValue, this.type);
    }

    public final ImmutableFormRevisionDocument withType(DialobDocument.DocumentType value) {
        if (this.type == value) {
            return this;
        }
        DialobDocument.DocumentType newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableFormRevisionDocument(this.id, this.version, this.description, this.name, this.created, this.head, this.updated, this.entries, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFormRevisionDocument && this.equalTo((ImmutableFormRevisionDocument)another);
    }

    private boolean equalTo(ImmutableFormRevisionDocument another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.version, another.version) && Objects.equals(this.description, another.description) && this.name.equals(another.name) && this.created.equals(another.created) && this.head.equals(another.head) && this.updated.equals(another.updated) && this.entries.equals(another.entries) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.version);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.created.hashCode();
        h += (h << 5) + this.head.hashCode();
        h += (h << 5) + this.updated.hashCode();
        h += (h << 5) + this.entries.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FormRevisionDocument").omitNullValues().add("id", (Object)this.id).add("version", (Object)this.version).add("description", (Object)this.description).add("name", (Object)this.name).add("created", (Object)this.created).add("head", (Object)this.head).add("updated", (Object)this.updated).add("entries", this.entries).add("type", (Object)this.type).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFormRevisionDocument fromJson(Json json) {
        Builder builder = ImmutableFormRevisionDocument.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.created != null) {
            builder.created(json.created);
        }
        if (json.head != null) {
            builder.head(json.head);
        }
        if (json.updated != null) {
            builder.updated(json.updated);
        }
        if (json.entries != null) {
            builder.addAllEntries(json.entries);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        return builder.build();
    }

    public static ImmutableFormRevisionDocument copyOf(DialobDocument.FormRevisionDocument instance) {
        if (instance instanceof ImmutableFormRevisionDocument) {
            return (ImmutableFormRevisionDocument)instance;
        }
        return ImmutableFormRevisionDocument.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobDocument.FormRevisionDocument", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_CREATED = 2L;
        private static final long INIT_BIT_HEAD = 4L;
        private static final long INIT_BIT_UPDATED = 8L;
        private long initBits = 15L;
        @Nullable
        private String id;
        @Nullable
        private String version;
        @Nullable
        private String description;
        @Nullable
        private String name;
        @Nullable
        private LocalDateTime created;
        @Nullable
        private String head;
        @Nullable
        private LocalDateTime updated;
        private ImmutableList.Builder<DialobDocument.FormRevisionEntryDocument> entries = ImmutableList.builder();
        @Nullable
        private DialobDocument.DocumentType type;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobDocument.FormRevisionDocument instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobDocument instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DialobDocument instance;
            long bits = 0L;
            if (object instanceof DialobDocument.FormRevisionDocument) {
                instance = (DialobDocument.FormRevisionDocument)object;
                this.head(instance.getHead());
                this.addAllEntries(instance.getEntries());
                if ((bits & 1L) == 0L) {
                    this.type(instance.getType());
                    bits |= 1L;
                }
                this.updated(instance.getUpdated());
            }
            if (object instanceof DialobDocument) {
                String versionValue;
                String idValue;
                instance = (DialobDocument)object;
                this.name(instance.getName());
                String descriptionValue = instance.getDescription();
                if (descriptionValue != null) {
                    this.description(descriptionValue);
                }
                if ((idValue = instance.getId()) != null) {
                    this.id(idValue);
                }
                if ((bits & 1L) == 0L) {
                    this.type(instance.getType());
                    bits |= 1L;
                }
                if ((versionValue = instance.getVersion()) != null) {
                    this.version(versionValue);
                }
                this.created(instance.getCreated());
            }
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="version")
        @CanIgnoreReturnValue
        public final Builder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="created")
        @CanIgnoreReturnValue
        public final Builder created(LocalDateTime created) {
            this.created = Objects.requireNonNull(created, "created");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="head")
        @CanIgnoreReturnValue
        public final Builder head(String head) {
            this.head = Objects.requireNonNull(head, "head");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="updated")
        @CanIgnoreReturnValue
        public final Builder updated(LocalDateTime updated) {
            this.updated = Objects.requireNonNull(updated, "updated");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEntries(DialobDocument.FormRevisionEntryDocument element) {
            this.entries.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEntries(DialobDocument.FormRevisionEntryDocument ... elements) {
            this.entries.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="entries")
        @CanIgnoreReturnValue
        public final Builder entries(Iterable<? extends DialobDocument.FormRevisionEntryDocument> elements) {
            this.entries = ImmutableList.builder();
            return this.addAllEntries(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllEntries(Iterable<? extends DialobDocument.FormRevisionEntryDocument> elements) {
            this.entries.addAll(elements);
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(DialobDocument.DocumentType type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        public ImmutableFormRevisionDocument build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFormRevisionDocument(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("created");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("head");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("updated");
            }
            return "Cannot build FormRevisionDocument, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DialobDocument.FormRevisionDocument", generator="Immutables")
    static final class Json
    implements DialobDocument.FormRevisionDocument {
        @Nullable
        String id;
        @Nullable
        String version;
        @Nullable
        String description;
        @Nullable
        String name;
        @Nullable
        LocalDateTime created;
        @Nullable
        String head;
        @Nullable
        LocalDateTime updated;
        @Nullable
        List<DialobDocument.FormRevisionEntryDocument> entries = ImmutableList.of();
        @Nullable
        DialobDocument.DocumentType type;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="version")
        public void setVersion(@Nullable String version) {
            this.version = version;
        }

        @JsonProperty(value="description")
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="created")
        public void setCreated(LocalDateTime created) {
            this.created = created;
        }

        @JsonProperty(value="head")
        public void setHead(String head) {
            this.head = head;
        }

        @JsonProperty(value="updated")
        public void setUpdated(LocalDateTime updated) {
            this.updated = updated;
        }

        @JsonProperty(value="entries")
        public void setEntries(List<DialobDocument.FormRevisionEntryDocument> entries) {
            this.entries = entries;
        }

        @JsonProperty(value="type")
        public void setType(DialobDocument.DocumentType type) {
            this.type = type;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LocalDateTime getCreated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHead() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LocalDateTime getUpdated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<DialobDocument.FormRevisionEntryDocument> getEntries() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DialobDocument.DocumentType getType() {
            throw new UnsupportedOperationException();
        }
    }
}

