/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.api.DialobDocument;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobDocument.FormReleaseValueDocument", generator="Immutables")
@Immutable
public final class ImmutableFormReleaseValueDocument
implements DialobDocument.FormReleaseValueDocument {
    private final String hash;
    private final DialobDocument.DocumentType bodyType;
    @Nullable
    private final String description;
    private final String commands;

    private ImmutableFormReleaseValueDocument(String hash, DialobDocument.DocumentType bodyType, @Nullable String description, String commands) {
        this.hash = hash;
        this.bodyType = bodyType;
        this.description = description;
        this.commands = commands;
    }

    @Override
    @JsonProperty(value="hash")
    public String getHash() {
        return this.hash;
    }

    @Override
    @JsonProperty(value="bodyType")
    public DialobDocument.DocumentType getBodyType() {
        return this.bodyType;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="commands")
    public String getCommands() {
        return this.commands;
    }

    public final ImmutableFormReleaseValueDocument withHash(String value) {
        String newValue = Objects.requireNonNull(value, "hash");
        if (this.hash.equals(newValue)) {
            return this;
        }
        return new ImmutableFormReleaseValueDocument(newValue, this.bodyType, this.description, this.commands);
    }

    public final ImmutableFormReleaseValueDocument withBodyType(DialobDocument.DocumentType value) {
        if (this.bodyType == value) {
            return this;
        }
        DialobDocument.DocumentType newValue = Objects.requireNonNull(value, "bodyType");
        if (this.bodyType.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableFormReleaseValueDocument(this.hash, newValue, this.description, this.commands);
    }

    public final ImmutableFormReleaseValueDocument withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableFormReleaseValueDocument(this.hash, this.bodyType, value, this.commands);
    }

    public final ImmutableFormReleaseValueDocument withCommands(String value) {
        String newValue = Objects.requireNonNull(value, "commands");
        if (this.commands.equals(newValue)) {
            return this;
        }
        return new ImmutableFormReleaseValueDocument(this.hash, this.bodyType, this.description, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFormReleaseValueDocument && this.equalTo((ImmutableFormReleaseValueDocument)another);
    }

    private boolean equalTo(ImmutableFormReleaseValueDocument another) {
        return this.hash.equals(another.hash) && this.bodyType.equals((Object)another.bodyType) && Objects.equals(this.description, another.description) && this.commands.equals(another.commands);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + this.bodyType.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.commands.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FormReleaseValueDocument").omitNullValues().add("hash", (Object)this.hash).add("bodyType", (Object)this.bodyType).add("description", (Object)this.description).add("commands", (Object)this.commands).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFormReleaseValueDocument fromJson(Json json) {
        Builder builder = ImmutableFormReleaseValueDocument.builder();
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        if (json.bodyType != null) {
            builder.bodyType(json.bodyType);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.commands != null) {
            builder.commands(json.commands);
        }
        return builder.build();
    }

    public static ImmutableFormReleaseValueDocument copyOf(DialobDocument.FormReleaseValueDocument instance) {
        if (instance instanceof ImmutableFormReleaseValueDocument) {
            return (ImmutableFormReleaseValueDocument)instance;
        }
        return ImmutableFormReleaseValueDocument.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobDocument.FormReleaseValueDocument", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long INIT_BIT_BODY_TYPE = 2L;
        private static final long INIT_BIT_COMMANDS = 4L;
        private long initBits = 7L;
        @Nullable
        private String hash;
        @Nullable
        private DialobDocument.DocumentType bodyType;
        @Nullable
        private String description;
        @Nullable
        private String commands;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobDocument.FormReleaseValueDocument instance) {
            Objects.requireNonNull(instance, "instance");
            this.hash(instance.getHash());
            this.bodyType(instance.getBodyType());
            String descriptionValue = instance.getDescription();
            if (descriptionValue != null) {
                this.description(descriptionValue);
            }
            this.commands(instance.getCommands());
            return this;
        }

        @JsonProperty(value="hash")
        @CanIgnoreReturnValue
        public final Builder hash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="bodyType")
        @CanIgnoreReturnValue
        public final Builder bodyType(DialobDocument.DocumentType bodyType) {
            this.bodyType = Objects.requireNonNull(bodyType, "bodyType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="commands")
        @CanIgnoreReturnValue
        public final Builder commands(String commands) {
            this.commands = Objects.requireNonNull(commands, "commands");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableFormReleaseValueDocument build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFormReleaseValueDocument(this.hash, this.bodyType, this.description, this.commands);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("bodyType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("commands");
            }
            return "Cannot build FormReleaseValueDocument, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DialobDocument.FormReleaseValueDocument", generator="Immutables")
    static final class Json
    implements DialobDocument.FormReleaseValueDocument {
        @Nullable
        String hash;
        @Nullable
        DialobDocument.DocumentType bodyType;
        @Nullable
        String description;
        @Nullable
        String commands;

        Json() {
        }

        @JsonProperty(value="hash")
        public void setHash(String hash) {
            this.hash = hash;
        }

        @JsonProperty(value="bodyType")
        public void setBodyType(DialobDocument.DocumentType bodyType) {
            this.bodyType = bodyType;
        }

        @JsonProperty(value="description")
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @JsonProperty(value="commands")
        public void setCommands(String commands) {
            this.commands = commands;
        }

        @Override
        public String getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DialobDocument.DocumentType getBodyType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCommands() {
            throw new UnsupportedOperationException();
        }
    }
}

