/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.api.DialobDocument;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobDocument.FormReleaseDocument", generator="Immutables")
@Immutable
public final class ImmutableFormReleaseDocument
implements DialobDocument.FormReleaseDocument {
    @Nullable
    private final String id;
    @Nullable
    private final String version;
    @Nullable
    private final String description;
    private final String name;
    private final LocalDateTime created;
    private final ImmutableList<DialobDocument.FormReleaseValueDocument> values;
    private final DialobDocument.DocumentType type;

    private ImmutableFormReleaseDocument(Builder builder) {
        this.id = builder.id;
        this.version = builder.version;
        this.description = builder.description;
        this.name = builder.name;
        this.created = builder.created;
        this.values = builder.values.build();
        this.type = builder.type != null ? builder.type : Objects.requireNonNull(DialobDocument.FormReleaseDocument.super.getType(), "type");
    }

    private ImmutableFormReleaseDocument(@Nullable String id, @Nullable String version, @Nullable String description, String name, LocalDateTime created, ImmutableList<DialobDocument.FormReleaseValueDocument> values, DialobDocument.DocumentType type) {
        this.id = id;
        this.version = version;
        this.description = description;
        this.name = name;
        this.created = created;
        this.values = values;
        this.type = type;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="version")
    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="created")
    public LocalDateTime getCreated() {
        return this.created;
    }

    @JsonProperty(value="values")
    public ImmutableList<DialobDocument.FormReleaseValueDocument> getValues() {
        return this.values;
    }

    @Override
    @JsonProperty(value="type")
    public DialobDocument.DocumentType getType() {
        return this.type;
    }

    public final ImmutableFormReleaseDocument withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableFormReleaseDocument(value, this.version, this.description, this.name, this.created, this.values, this.type);
    }

    public final ImmutableFormReleaseDocument withVersion(@Nullable String value) {
        if (Objects.equals(this.version, value)) {
            return this;
        }
        return new ImmutableFormReleaseDocument(this.id, value, this.description, this.name, this.created, this.values, this.type);
    }

    public final ImmutableFormReleaseDocument withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableFormReleaseDocument(this.id, this.version, value, this.name, this.created, this.values, this.type);
    }

    public final ImmutableFormReleaseDocument withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableFormReleaseDocument(this.id, this.version, this.description, newValue, this.created, this.values, this.type);
    }

    public final ImmutableFormReleaseDocument withCreated(LocalDateTime value) {
        if (this.created == value) {
            return this;
        }
        LocalDateTime newValue = Objects.requireNonNull(value, "created");
        return new ImmutableFormReleaseDocument(this.id, this.version, this.description, this.name, newValue, this.values, this.type);
    }

    public final ImmutableFormReleaseDocument withValues(DialobDocument.FormReleaseValueDocument ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableFormReleaseDocument(this.id, this.version, this.description, this.name, this.created, (ImmutableList<DialobDocument.FormReleaseValueDocument>)newValue, this.type);
    }

    public final ImmutableFormReleaseDocument withValues(Iterable<? extends DialobDocument.FormReleaseValueDocument> elements) {
        if (this.values == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableFormReleaseDocument(this.id, this.version, this.description, this.name, this.created, (ImmutableList<DialobDocument.FormReleaseValueDocument>)newValue, this.type);
    }

    public final ImmutableFormReleaseDocument withType(DialobDocument.DocumentType value) {
        if (this.type == value) {
            return this;
        }
        DialobDocument.DocumentType newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableFormReleaseDocument(this.id, this.version, this.description, this.name, this.created, this.values, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFormReleaseDocument && this.equalTo((ImmutableFormReleaseDocument)another);
    }

    private boolean equalTo(ImmutableFormReleaseDocument another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.version, another.version) && Objects.equals(this.description, another.description) && this.name.equals(another.name) && this.created.equals(another.created) && this.values.equals(another.values) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.version);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.created.hashCode();
        h += (h << 5) + this.values.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FormReleaseDocument").omitNullValues().add("id", (Object)this.id).add("version", (Object)this.version).add("description", (Object)this.description).add("name", (Object)this.name).add("created", (Object)this.created).add("values", this.values).add("type", (Object)this.type).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFormReleaseDocument fromJson(Json json) {
        Builder builder = ImmutableFormReleaseDocument.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.created != null) {
            builder.created(json.created);
        }
        if (json.values != null) {
            builder.addAllValues(json.values);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        return builder.build();
    }

    public static ImmutableFormReleaseDocument copyOf(DialobDocument.FormReleaseDocument instance) {
        if (instance instanceof ImmutableFormReleaseDocument) {
            return (ImmutableFormReleaseDocument)instance;
        }
        return ImmutableFormReleaseDocument.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobDocument.FormReleaseDocument", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_CREATED = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private String version;
        @Nullable
        private String description;
        @Nullable
        private String name;
        @Nullable
        private LocalDateTime created;
        private ImmutableList.Builder<DialobDocument.FormReleaseValueDocument> values = ImmutableList.builder();
        @Nullable
        private DialobDocument.DocumentType type;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobDocument instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobDocument.FormReleaseDocument instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DialobDocument instance;
            long bits = 0L;
            if (object instanceof DialobDocument) {
                String versionValue;
                String idValue;
                instance = (DialobDocument)object;
                this.name(instance.getName());
                String descriptionValue = instance.getDescription();
                if (descriptionValue != null) {
                    this.description(descriptionValue);
                }
                if ((idValue = instance.getId()) != null) {
                    this.id(idValue);
                }
                if ((bits & 2L) == 0L) {
                    this.type(instance.getType());
                    bits |= 2L;
                }
                if ((versionValue = instance.getVersion()) != null) {
                    this.version(versionValue);
                }
                if ((bits & 1L) == 0L) {
                    this.created(instance.getCreated());
                    bits |= 1L;
                }
            }
            if (object instanceof DialobDocument.FormReleaseDocument) {
                instance = (DialobDocument.FormReleaseDocument)object;
                if ((bits & 2L) == 0L) {
                    this.type(instance.getType());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.created(instance.getCreated());
                    bits |= 1L;
                }
                this.addAllValues(instance.getValues());
            }
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="version")
        @CanIgnoreReturnValue
        public final Builder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="created")
        @CanIgnoreReturnValue
        public final Builder created(LocalDateTime created) {
            this.created = Objects.requireNonNull(created, "created");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addValues(DialobDocument.FormReleaseValueDocument element) {
            this.values.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addValues(DialobDocument.FormReleaseValueDocument ... elements) {
            this.values.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="values")
        @CanIgnoreReturnValue
        public final Builder values(Iterable<? extends DialobDocument.FormReleaseValueDocument> elements) {
            this.values = ImmutableList.builder();
            return this.addAllValues(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllValues(Iterable<? extends DialobDocument.FormReleaseValueDocument> elements) {
            this.values.addAll(elements);
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(DialobDocument.DocumentType type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        public ImmutableFormReleaseDocument build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFormReleaseDocument(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("created");
            }
            return "Cannot build FormReleaseDocument, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DialobDocument.FormReleaseDocument", generator="Immutables")
    static final class Json
    implements DialobDocument.FormReleaseDocument {
        @Nullable
        String id;
        @Nullable
        String version;
        @Nullable
        String description;
        @Nullable
        String name;
        @Nullable
        LocalDateTime created;
        @Nullable
        List<DialobDocument.FormReleaseValueDocument> values = ImmutableList.of();
        @Nullable
        DialobDocument.DocumentType type;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="version")
        public void setVersion(@Nullable String version) {
            this.version = version;
        }

        @JsonProperty(value="description")
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="created")
        public void setCreated(LocalDateTime created) {
            this.created = created;
        }

        @JsonProperty(value="values")
        public void setValues(List<DialobDocument.FormReleaseValueDocument> values) {
            this.values = values;
        }

        @JsonProperty(value="type")
        public void setType(DialobDocument.DocumentType type) {
            this.type = type;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LocalDateTime getCreated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<DialobDocument.FormReleaseValueDocument> getValues() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DialobDocument.DocumentType getType() {
            throw new UnsupportedOperationException();
        }
    }
}

