/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.api.form.Form;
import io.dialob.client.api.DialobDocument;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobDocument.FormDocument", generator="Immutables")
@Immutable
public final class ImmutableFormDocument
implements DialobDocument.FormDocument {
    @Nullable
    private final String id;
    @Nullable
    private final String version;
    @Nullable
    private final String description;
    private final LocalDateTime created;
    private final Form data;
    private final LocalDateTime updated;
    private final DialobDocument.DocumentType type;
    private final String name;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFormDocument(Builder builder) {
        this.id = builder.id;
        this.version = builder.version;
        this.description = builder.description;
        this.created = builder.created;
        this.data = builder.data;
        this.updated = builder.updated;
        if (builder.type != null) {
            this.initShim.type(builder.type);
        }
        if (builder.name != null) {
            this.initShim.name(builder.name);
        }
        this.type = this.initShim.getType();
        this.name = this.initShim.getName();
        this.initShim = null;
    }

    private ImmutableFormDocument(@Nullable String id, @Nullable String version, @Nullable String description, LocalDateTime created, Form data, LocalDateTime updated, DialobDocument.DocumentType type, String name) {
        this.id = id;
        this.version = version;
        this.description = description;
        this.created = created;
        this.data = data;
        this.updated = updated;
        this.type = type;
        this.name = name;
        this.initShim = null;
    }

    private DialobDocument.DocumentType getTypeInitialize() {
        return DialobDocument.FormDocument.super.getType();
    }

    private String getNameInitialize() {
        return DialobDocument.FormDocument.super.getName();
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="version")
    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="created")
    public LocalDateTime getCreated() {
        return this.created;
    }

    @Override
    @JsonProperty(value="data")
    public Form getData() {
        return this.data;
    }

    @Override
    @JsonProperty(value="updated")
    public LocalDateTime getUpdated() {
        return this.updated;
    }

    @Override
    @JsonProperty(value="type")
    public DialobDocument.DocumentType getType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getType() : this.type;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getName() : this.name;
    }

    public final ImmutableFormDocument withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableFormDocument(value, this.version, this.description, this.created, this.data, this.updated, this.type, this.name);
    }

    public final ImmutableFormDocument withVersion(@Nullable String value) {
        if (Objects.equals(this.version, value)) {
            return this;
        }
        return new ImmutableFormDocument(this.id, value, this.description, this.created, this.data, this.updated, this.type, this.name);
    }

    public final ImmutableFormDocument withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableFormDocument(this.id, this.version, value, this.created, this.data, this.updated, this.type, this.name);
    }

    public final ImmutableFormDocument withCreated(LocalDateTime value) {
        if (this.created == value) {
            return this;
        }
        LocalDateTime newValue = Objects.requireNonNull(value, "created");
        return new ImmutableFormDocument(this.id, this.version, this.description, newValue, this.data, this.updated, this.type, this.name);
    }

    public final ImmutableFormDocument withData(Form value) {
        if (this.data == value) {
            return this;
        }
        Form newValue = Objects.requireNonNull(value, "data");
        return new ImmutableFormDocument(this.id, this.version, this.description, this.created, newValue, this.updated, this.type, this.name);
    }

    public final ImmutableFormDocument withUpdated(LocalDateTime value) {
        if (this.updated == value) {
            return this;
        }
        LocalDateTime newValue = Objects.requireNonNull(value, "updated");
        return new ImmutableFormDocument(this.id, this.version, this.description, this.created, this.data, newValue, this.type, this.name);
    }

    public final ImmutableFormDocument withType(DialobDocument.DocumentType value) {
        if (this.type == value) {
            return this;
        }
        DialobDocument.DocumentType newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableFormDocument(this.id, this.version, this.description, this.created, this.data, this.updated, newValue, this.name);
    }

    public final ImmutableFormDocument withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableFormDocument(this.id, this.version, this.description, this.created, this.data, this.updated, this.type, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFormDocument && this.equalTo((ImmutableFormDocument)another);
    }

    private boolean equalTo(ImmutableFormDocument another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.version, another.version) && Objects.equals(this.description, another.description) && this.created.equals(another.created) && this.data.equals(another.data) && this.updated.equals(another.updated) && this.type.equals((Object)another.type) && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.version);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.created.hashCode();
        h += (h << 5) + this.data.hashCode();
        h += (h << 5) + this.updated.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FormDocument").omitNullValues().add("id", (Object)this.id).add("version", (Object)this.version).add("description", (Object)this.description).add("created", (Object)this.created).add("data", (Object)this.data).add("updated", (Object)this.updated).add("type", (Object)this.type).add("name", (Object)this.name).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFormDocument fromJson(Json json) {
        Builder builder = ImmutableFormDocument.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.created != null) {
            builder.created(json.created);
        }
        if (json.data != null) {
            builder.data(json.data);
        }
        if (json.updated != null) {
            builder.updated(json.updated);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        return builder.build();
    }

    public static ImmutableFormDocument copyOf(DialobDocument.FormDocument instance) {
        if (instance instanceof ImmutableFormDocument) {
            return (ImmutableFormDocument)instance;
        }
        return ImmutableFormDocument.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobDocument.FormDocument", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CREATED = 1L;
        private static final long INIT_BIT_DATA = 2L;
        private static final long INIT_BIT_UPDATED = 4L;
        private long initBits = 7L;
        @Nullable
        private String id;
        @Nullable
        private String version;
        @Nullable
        private String description;
        @Nullable
        private LocalDateTime created;
        @Nullable
        private Form data;
        @Nullable
        private LocalDateTime updated;
        @Nullable
        private DialobDocument.DocumentType type;
        @Nullable
        private String name;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobDocument.FormDocument instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobDocument instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DialobDocument instance;
            long bits = 0L;
            if (object instanceof DialobDocument.FormDocument) {
                instance = (DialobDocument.FormDocument)object;
                if ((bits & 1L) == 0L) {
                    this.name(instance.getName());
                    bits |= 1L;
                }
                this.data(instance.getData());
                if ((bits & 2L) == 0L) {
                    this.type(instance.getType());
                    bits |= 2L;
                }
                this.updated(instance.getUpdated());
            }
            if (object instanceof DialobDocument) {
                String versionValue;
                String idValue;
                String descriptionValue;
                instance = (DialobDocument)object;
                if ((bits & 1L) == 0L) {
                    this.name(instance.getName());
                    bits |= 1L;
                }
                if ((descriptionValue = instance.getDescription()) != null) {
                    this.description(descriptionValue);
                }
                if ((idValue = instance.getId()) != null) {
                    this.id(idValue);
                }
                if ((bits & 2L) == 0L) {
                    this.type(instance.getType());
                    bits |= 2L;
                }
                if ((versionValue = instance.getVersion()) != null) {
                    this.version(versionValue);
                }
                this.created(instance.getCreated());
            }
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="version")
        @CanIgnoreReturnValue
        public final Builder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="created")
        @CanIgnoreReturnValue
        public final Builder created(LocalDateTime created) {
            this.created = Objects.requireNonNull(created, "created");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="data")
        @CanIgnoreReturnValue
        public final Builder data(Form data) {
            this.data = Objects.requireNonNull(data, "data");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="updated")
        @CanIgnoreReturnValue
        public final Builder updated(LocalDateTime updated) {
            this.updated = Objects.requireNonNull(updated, "updated");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(DialobDocument.DocumentType type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        public ImmutableFormDocument build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFormDocument(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("created");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("data");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("updated");
            }
            return "Cannot build FormDocument, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DialobDocument.FormDocument", generator="Immutables")
    static final class Json
    implements DialobDocument.FormDocument {
        @Nullable
        String id;
        @Nullable
        String version;
        @Nullable
        String description;
        @Nullable
        LocalDateTime created;
        @Nullable
        Form data;
        @Nullable
        LocalDateTime updated;
        @Nullable
        DialobDocument.DocumentType type;
        @Nullable
        String name;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="version")
        public void setVersion(@Nullable String version) {
            this.version = version;
        }

        @JsonProperty(value="description")
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @JsonProperty(value="created")
        public void setCreated(LocalDateTime created) {
            this.created = created;
        }

        @JsonProperty(value="data")
        public void setData(Form data) {
            this.data = data;
        }

        @JsonProperty(value="updated")
        public void setUpdated(LocalDateTime updated) {
            this.updated = updated;
        }

        @JsonProperty(value="type")
        public void setType(DialobDocument.DocumentType type) {
            this.type = type;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LocalDateTime getCreated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Form getData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LocalDateTime getUpdated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DialobDocument.DocumentType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="DialobDocument.FormDocument", generator="Immutables")
    private final class InitShim {
        private byte typeBuildStage = 0;
        private DialobDocument.DocumentType type;
        private byte nameBuildStage = 0;
        private String name;

        private InitShim() {
        }

        DialobDocument.DocumentType getType() {
            if (this.typeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.typeBuildStage == 0) {
                this.typeBuildStage = (byte)-1;
                this.type = Objects.requireNonNull(ImmutableFormDocument.this.getTypeInitialize(), "type");
                this.typeBuildStage = 1;
            }
            return this.type;
        }

        void type(DialobDocument.DocumentType type) {
            this.type = type;
            this.typeBuildStage = 1;
        }

        String getName() {
            if (this.nameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nameBuildStage == 0) {
                this.nameBuildStage = (byte)-1;
                this.name = Objects.requireNonNull(ImmutableFormDocument.this.getNameInitialize(), "name");
                this.nameBuildStage = 1;
            }
            return this.name;
        }

        void name(String name) {
            this.name = name;
            this.nameBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.typeBuildStage == -1) {
                attributes.add("type");
            }
            if (this.nameBuildStage == -1) {
                attributes.add("name");
            }
            return "Cannot build FormDocument, attribute initializers form cycle " + attributes;
        }
    }
}

