/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.api.form.Form;
import io.dialob.client.api.DialobComposer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobComposer.FormCommands", generator="Immutables")
@Immutable
public final class ImmutableFormCommands
implements DialobComposer.FormCommands {
    private final Form form;
    private final ImmutableList<DialobComposer.FormCommand> values;

    private ImmutableFormCommands(Form form, ImmutableList<DialobComposer.FormCommand> values) {
        this.form = form;
        this.values = values;
    }

    @Override
    @JsonProperty(value="form")
    public Form getForm() {
        return this.form;
    }

    @JsonProperty(value="values")
    public ImmutableList<DialobComposer.FormCommand> getValues() {
        return this.values;
    }

    public final ImmutableFormCommands withForm(Form value) {
        if (this.form == value) {
            return this;
        }
        Form newValue = Objects.requireNonNull(value, "form");
        return new ImmutableFormCommands(newValue, this.values);
    }

    public final ImmutableFormCommands withValues(DialobComposer.FormCommand ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableFormCommands(this.form, (ImmutableList<DialobComposer.FormCommand>)newValue);
    }

    public final ImmutableFormCommands withValues(Iterable<? extends DialobComposer.FormCommand> elements) {
        if (this.values == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableFormCommands(this.form, (ImmutableList<DialobComposer.FormCommand>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFormCommands && this.equalTo((ImmutableFormCommands)another);
    }

    private boolean equalTo(ImmutableFormCommands another) {
        return this.form.equals(another.form) && this.values.equals(another.values);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.form.hashCode();
        h += (h << 5) + this.values.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FormCommands").omitNullValues().add("form", (Object)this.form).add("values", this.values).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFormCommands fromJson(Json json) {
        Builder builder = ImmutableFormCommands.builder();
        if (json.form != null) {
            builder.form(json.form);
        }
        if (json.values != null) {
            builder.addAllValues(json.values);
        }
        return builder.build();
    }

    public static ImmutableFormCommands copyOf(DialobComposer.FormCommands instance) {
        if (instance instanceof ImmutableFormCommands) {
            return (ImmutableFormCommands)instance;
        }
        return ImmutableFormCommands.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobComposer.FormCommands", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FORM = 1L;
        private long initBits = 1L;
        @Nullable
        private Form form;
        private ImmutableList.Builder<DialobComposer.FormCommand> values = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobComposer.FormCommands instance) {
            Objects.requireNonNull(instance, "instance");
            this.form(instance.getForm());
            this.addAllValues(instance.getValues());
            return this;
        }

        @JsonProperty(value="form")
        @CanIgnoreReturnValue
        public final Builder form(Form form) {
            this.form = Objects.requireNonNull(form, "form");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addValues(DialobComposer.FormCommand element) {
            this.values.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addValues(DialobComposer.FormCommand ... elements) {
            this.values.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="values")
        @CanIgnoreReturnValue
        public final Builder values(Iterable<? extends DialobComposer.FormCommand> elements) {
            this.values = ImmutableList.builder();
            return this.addAllValues(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllValues(Iterable<? extends DialobComposer.FormCommand> elements) {
            this.values.addAll(elements);
            return this;
        }

        public ImmutableFormCommands build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFormCommands(this.form, (ImmutableList<DialobComposer.FormCommand>)this.values.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("form");
            }
            return "Cannot build FormCommands, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DialobComposer.FormCommands", generator="Immutables")
    static final class Json
    implements DialobComposer.FormCommands {
        @Nullable
        Form form;
        @Nullable
        List<DialobComposer.FormCommand> values = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="form")
        public void setForm(Form form) {
            this.form = form;
        }

        @JsonProperty(value="values")
        public void setValues(List<DialobComposer.FormCommand> values) {
            this.values = values;
        }

        @Override
        public Form getForm() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<DialobComposer.FormCommand> getValues() {
            throw new UnsupportedOperationException();
        }
    }
}

