/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.api.form.Form;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.client.api.DialobFill;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobFill.FillEntry", generator="Immutables")
@Immutable
public final class ImmutableFillEntry
implements DialobFill.FillEntry {
    private final String id;
    private final Questionnaire questionnaire;
    private final Form form;

    private ImmutableFillEntry(String id, Questionnaire questionnaire, Form form) {
        this.id = id;
        this.questionnaire = questionnaire;
        this.form = form;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Questionnaire getQuestionnaire() {
        return this.questionnaire;
    }

    @Override
    public Form getForm() {
        return this.form;
    }

    public final ImmutableFillEntry withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableFillEntry(newValue, this.questionnaire, this.form);
    }

    public final ImmutableFillEntry withQuestionnaire(Questionnaire value) {
        if (this.questionnaire == value) {
            return this;
        }
        Questionnaire newValue = Objects.requireNonNull(value, "questionnaire");
        return new ImmutableFillEntry(this.id, newValue, this.form);
    }

    public final ImmutableFillEntry withForm(Form value) {
        if (this.form == value) {
            return this;
        }
        Form newValue = Objects.requireNonNull(value, "form");
        return new ImmutableFillEntry(this.id, this.questionnaire, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFillEntry && this.equalTo((ImmutableFillEntry)another);
    }

    private boolean equalTo(ImmutableFillEntry another) {
        return this.id.equals(another.id) && this.questionnaire.equals(another.questionnaire) && this.form.equals(another.form);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.questionnaire.hashCode();
        h += (h << 5) + this.form.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FillEntry").omitNullValues().add("id", (Object)this.id).add("questionnaire", (Object)this.questionnaire).add("form", (Object)this.form).toString();
    }

    public static ImmutableFillEntry copyOf(DialobFill.FillEntry instance) {
        if (instance instanceof ImmutableFillEntry) {
            return (ImmutableFillEntry)instance;
        }
        return ImmutableFillEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobFill.FillEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_QUESTIONNAIRE = 2L;
        private static final long INIT_BIT_FORM = 4L;
        private long initBits = 7L;
        @Nullable
        private String id;
        @Nullable
        private Questionnaire questionnaire;
        @Nullable
        private Form form;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobFill.FillEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.questionnaire(instance.getQuestionnaire());
            this.form(instance.getForm());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder questionnaire(Questionnaire questionnaire) {
            this.questionnaire = Objects.requireNonNull(questionnaire, "questionnaire");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder form(Form form) {
            this.form = Objects.requireNonNull(form, "form");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableFillEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFillEntry(this.id, this.questionnaire, this.form);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("questionnaire");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("form");
            }
            return "Cannot build FillEntry, some of required attributes are not set " + attributes;
        }
    }
}

