/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.api.proto.Actions;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.client.api.DialobClient;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobClient.ExecutorBody", generator="Immutables")
@Immutable
public final class ImmutableExecutorBody
implements DialobClient.ExecutorBody {
    private final Actions actions;
    private final Questionnaire questionnaire;

    private ImmutableExecutorBody(Actions actions, Questionnaire questionnaire) {
        this.actions = actions;
        this.questionnaire = questionnaire;
    }

    @Override
    public Actions getActions() {
        return this.actions;
    }

    @Override
    public Questionnaire getQuestionnaire() {
        return this.questionnaire;
    }

    public final ImmutableExecutorBody withActions(Actions value) {
        if (this.actions == value) {
            return this;
        }
        Actions newValue = Objects.requireNonNull(value, "actions");
        return new ImmutableExecutorBody(newValue, this.questionnaire);
    }

    public final ImmutableExecutorBody withQuestionnaire(Questionnaire value) {
        if (this.questionnaire == value) {
            return this;
        }
        Questionnaire newValue = Objects.requireNonNull(value, "questionnaire");
        return new ImmutableExecutorBody(this.actions, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExecutorBody && this.equalTo((ImmutableExecutorBody)another);
    }

    private boolean equalTo(ImmutableExecutorBody another) {
        return this.actions.equals(another.actions) && this.questionnaire.equals(another.questionnaire);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.actions.hashCode();
        h += (h << 5) + this.questionnaire.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ExecutorBody").omitNullValues().add("actions", (Object)this.actions).add("questionnaire", (Object)this.questionnaire).toString();
    }

    public static ImmutableExecutorBody copyOf(DialobClient.ExecutorBody instance) {
        if (instance instanceof ImmutableExecutorBody) {
            return (ImmutableExecutorBody)instance;
        }
        return ImmutableExecutorBody.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobClient.ExecutorBody", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACTIONS = 1L;
        private static final long INIT_BIT_QUESTIONNAIRE = 2L;
        private long initBits = 3L;
        @Nullable
        private Actions actions;
        @Nullable
        private Questionnaire questionnaire;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobClient.ExecutorBody instance) {
            Objects.requireNonNull(instance, "instance");
            this.actions(instance.getActions());
            this.questionnaire(instance.getQuestionnaire());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder actions(Actions actions) {
            this.actions = Objects.requireNonNull(actions, "actions");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder questionnaire(Questionnaire questionnaire) {
            this.questionnaire = Objects.requireNonNull(questionnaire, "questionnaire");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableExecutorBody build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExecutorBody(this.actions, this.questionnaire);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("actions");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("questionnaire");
            }
            return "Cannot build ExecutorBody, some of required attributes are not set " + attributes;
        }
    }
}

