/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobStore;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobStore.EmptyCommand", generator="Immutables")
@Immutable
public final class ImmutableEmptyCommand
implements DialobStore.EmptyCommand {
    private final DialobDocument.DocumentType bodyType;
    private final String id;
    private final String description;

    private ImmutableEmptyCommand(DialobDocument.DocumentType bodyType, String id, String description) {
        this.bodyType = bodyType;
        this.id = id;
        this.description = description;
    }

    @Override
    @JsonProperty(value="bodyType")
    public DialobDocument.DocumentType getBodyType() {
        return this.bodyType;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public final ImmutableEmptyCommand withBodyType(DialobDocument.DocumentType value) {
        if (this.bodyType == value) {
            return this;
        }
        DialobDocument.DocumentType newValue = Objects.requireNonNull(value, "bodyType");
        if (this.bodyType.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableEmptyCommand(newValue, this.id, this.description);
    }

    public final ImmutableEmptyCommand withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableEmptyCommand(this.bodyType, newValue, this.description);
    }

    public final ImmutableEmptyCommand withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableEmptyCommand(this.bodyType, this.id, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEmptyCommand && this.equalTo((ImmutableEmptyCommand)another);
    }

    private boolean equalTo(ImmutableEmptyCommand another) {
        return this.bodyType.equals((Object)another.bodyType) && this.id.equals(another.id) && this.description.equals(another.description);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.bodyType.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.description.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EmptyCommand").omitNullValues().add("bodyType", (Object)this.bodyType).add("id", (Object)this.id).add("description", (Object)this.description).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEmptyCommand fromJson(Json json) {
        Builder builder = ImmutableEmptyCommand.builder();
        if (json.bodyType != null) {
            builder.bodyType(json.bodyType);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        return builder.build();
    }

    public static ImmutableEmptyCommand copyOf(DialobStore.EmptyCommand instance) {
        if (instance instanceof ImmutableEmptyCommand) {
            return (ImmutableEmptyCommand)instance;
        }
        return ImmutableEmptyCommand.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobStore.EmptyCommand", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BODY_TYPE = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_DESCRIPTION = 4L;
        private long initBits = 7L;
        @Nullable
        private DialobDocument.DocumentType bodyType;
        @Nullable
        private String id;
        @Nullable
        private String description;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobStore.EmptyCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobStore.StoreCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DialobStore.StoreCommand instance;
            if (object instanceof DialobStore.EmptyCommand) {
                instance = (DialobStore.EmptyCommand)object;
                this.description(instance.getDescription());
                this.id(instance.getId());
            }
            if (object instanceof DialobStore.StoreCommand) {
                instance = (DialobStore.StoreCommand)object;
                this.bodyType(instance.getBodyType());
            }
        }

        @JsonProperty(value="bodyType")
        @CanIgnoreReturnValue
        public final Builder bodyType(DialobDocument.DocumentType bodyType) {
            this.bodyType = Objects.requireNonNull(bodyType, "bodyType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableEmptyCommand build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEmptyCommand(this.bodyType, this.id, this.description);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("bodyType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("description");
            }
            return "Cannot build EmptyCommand, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DialobStore.EmptyCommand", generator="Immutables")
    static final class Json
    implements DialobStore.EmptyCommand {
        @Nullable
        DialobDocument.DocumentType bodyType;
        @Nullable
        String id;
        @Nullable
        String description;

        Json() {
        }

        @JsonProperty(value="bodyType")
        public void setBodyType(DialobDocument.DocumentType bodyType) {
            this.bodyType = bodyType;
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public DialobDocument.DocumentType getBodyType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }
    }
}

