/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.api.DialobStore;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobStore.DialobCreds", generator="Immutables")
@Immutable
public final class ImmutableDialobCreds
implements DialobStore.DialobCreds {
    private final String user;
    private final String email;

    private ImmutableDialobCreds(String user, String email) {
        this.user = user;
        this.email = email;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    public final ImmutableDialobCreds withUser(String value) {
        String newValue = Objects.requireNonNull(value, "user");
        if (this.user.equals(newValue)) {
            return this;
        }
        return new ImmutableDialobCreds(newValue, this.email);
    }

    public final ImmutableDialobCreds withEmail(String value) {
        String newValue = Objects.requireNonNull(value, "email");
        if (this.email.equals(newValue)) {
            return this;
        }
        return new ImmutableDialobCreds(this.user, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDialobCreds && this.equalTo((ImmutableDialobCreds)another);
    }

    private boolean equalTo(ImmutableDialobCreds another) {
        return this.user.equals(another.user) && this.email.equals(another.email);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + this.email.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DialobCreds").omitNullValues().add("user", (Object)this.user).add("email", (Object)this.email).toString();
    }

    public static ImmutableDialobCreds copyOf(DialobStore.DialobCreds instance) {
        if (instance instanceof ImmutableDialobCreds) {
            return (ImmutableDialobCreds)instance;
        }
        return ImmutableDialobCreds.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobStore.DialobCreds", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USER = 1L;
        private static final long INIT_BIT_EMAIL = 2L;
        private long initBits = 3L;
        @Nullable
        private String user;
        @Nullable
        private String email;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobStore.DialobCreds instance) {
            Objects.requireNonNull(instance, "instance");
            this.user(instance.getUser());
            this.email(instance.getEmail());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder user(String user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder email(String email) {
            this.email = Objects.requireNonNull(email, "email");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableDialobCreds build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDialobCreds(this.user, this.email);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("user");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("email");
            }
            return "Cannot build DialobCreds, some of required attributes are not set " + attributes;
        }
    }
}

