/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.api.DialobCache;
import io.dialob.client.api.DialobClient;
import io.dialob.client.api.DialobClientConfig;
import io.dialob.client.api.DialobErrorHandler;
import io.dialob.client.api.DialobStore;
import io.dialob.client.spi.event.QuestionnaireEventPublisher;
import io.dialob.client.spi.function.AsyncFunctionInvoker;
import io.dialob.compiler.DialobProgramFromFormCompiler;
import io.dialob.program.DialobSessionEvalContextFactory;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobClientConfig", generator="Immutables")
@Immutable
public final class ImmutableDialobClientConfig
implements DialobClientConfig {
    private final DialobStore store;
    private final DialobCache cache;
    private final DialobSessionEvalContextFactory factory;
    private final AsyncFunctionInvoker asyncFunctionInvoker;
    private final QuestionnaireEventPublisher eventPublisher;
    private final DialobClient.TypesMapper mapper;
    private final DialobProgramFromFormCompiler compiler;
    private final DialobErrorHandler errorHandler;

    private ImmutableDialobClientConfig(DialobStore store, DialobCache cache, DialobSessionEvalContextFactory factory, AsyncFunctionInvoker asyncFunctionInvoker, QuestionnaireEventPublisher eventPublisher, DialobClient.TypesMapper mapper, DialobProgramFromFormCompiler compiler, DialobErrorHandler errorHandler) {
        this.store = store;
        this.cache = cache;
        this.factory = factory;
        this.asyncFunctionInvoker = asyncFunctionInvoker;
        this.eventPublisher = eventPublisher;
        this.mapper = mapper;
        this.compiler = compiler;
        this.errorHandler = errorHandler;
    }

    @Override
    public DialobStore getStore() {
        return this.store;
    }

    @Override
    public DialobCache getCache() {
        return this.cache;
    }

    @Override
    public DialobSessionEvalContextFactory getFactory() {
        return this.factory;
    }

    @Override
    public AsyncFunctionInvoker getAsyncFunctionInvoker() {
        return this.asyncFunctionInvoker;
    }

    @Override
    public QuestionnaireEventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    @Override
    public DialobClient.TypesMapper getMapper() {
        return this.mapper;
    }

    @Override
    public DialobProgramFromFormCompiler getCompiler() {
        return this.compiler;
    }

    @Override
    public DialobErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public final ImmutableDialobClientConfig withStore(DialobStore value) {
        if (this.store == value) {
            return this;
        }
        DialobStore newValue = Objects.requireNonNull(value, "store");
        return new ImmutableDialobClientConfig(newValue, this.cache, this.factory, this.asyncFunctionInvoker, this.eventPublisher, this.mapper, this.compiler, this.errorHandler);
    }

    public final ImmutableDialobClientConfig withCache(DialobCache value) {
        if (this.cache == value) {
            return this;
        }
        DialobCache newValue = Objects.requireNonNull(value, "cache");
        return new ImmutableDialobClientConfig(this.store, newValue, this.factory, this.asyncFunctionInvoker, this.eventPublisher, this.mapper, this.compiler, this.errorHandler);
    }

    public final ImmutableDialobClientConfig withFactory(DialobSessionEvalContextFactory value) {
        if (this.factory == value) {
            return this;
        }
        DialobSessionEvalContextFactory newValue = Objects.requireNonNull(value, "factory");
        return new ImmutableDialobClientConfig(this.store, this.cache, newValue, this.asyncFunctionInvoker, this.eventPublisher, this.mapper, this.compiler, this.errorHandler);
    }

    public final ImmutableDialobClientConfig withAsyncFunctionInvoker(AsyncFunctionInvoker value) {
        if (this.asyncFunctionInvoker == value) {
            return this;
        }
        AsyncFunctionInvoker newValue = Objects.requireNonNull(value, "asyncFunctionInvoker");
        return new ImmutableDialobClientConfig(this.store, this.cache, this.factory, newValue, this.eventPublisher, this.mapper, this.compiler, this.errorHandler);
    }

    public final ImmutableDialobClientConfig withEventPublisher(QuestionnaireEventPublisher value) {
        if (this.eventPublisher == value) {
            return this;
        }
        QuestionnaireEventPublisher newValue = Objects.requireNonNull(value, "eventPublisher");
        return new ImmutableDialobClientConfig(this.store, this.cache, this.factory, this.asyncFunctionInvoker, newValue, this.mapper, this.compiler, this.errorHandler);
    }

    public final ImmutableDialobClientConfig withMapper(DialobClient.TypesMapper value) {
        if (this.mapper == value) {
            return this;
        }
        DialobClient.TypesMapper newValue = Objects.requireNonNull(value, "mapper");
        return new ImmutableDialobClientConfig(this.store, this.cache, this.factory, this.asyncFunctionInvoker, this.eventPublisher, newValue, this.compiler, this.errorHandler);
    }

    public final ImmutableDialobClientConfig withCompiler(DialobProgramFromFormCompiler value) {
        if (this.compiler == value) {
            return this;
        }
        DialobProgramFromFormCompiler newValue = Objects.requireNonNull(value, "compiler");
        return new ImmutableDialobClientConfig(this.store, this.cache, this.factory, this.asyncFunctionInvoker, this.eventPublisher, this.mapper, newValue, this.errorHandler);
    }

    public final ImmutableDialobClientConfig withErrorHandler(DialobErrorHandler value) {
        if (this.errorHandler == value) {
            return this;
        }
        DialobErrorHandler newValue = Objects.requireNonNull(value, "errorHandler");
        return new ImmutableDialobClientConfig(this.store, this.cache, this.factory, this.asyncFunctionInvoker, this.eventPublisher, this.mapper, this.compiler, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDialobClientConfig && this.equalTo((ImmutableDialobClientConfig)another);
    }

    private boolean equalTo(ImmutableDialobClientConfig another) {
        return this.store.equals(another.store) && this.cache.equals(another.cache) && this.factory.equals(another.factory) && this.asyncFunctionInvoker.equals(another.asyncFunctionInvoker) && this.eventPublisher.equals(another.eventPublisher) && this.mapper.equals(another.mapper) && this.compiler.equals(another.compiler) && this.errorHandler.equals(another.errorHandler);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.store.hashCode();
        h += (h << 5) + this.cache.hashCode();
        h += (h << 5) + this.factory.hashCode();
        h += (h << 5) + this.asyncFunctionInvoker.hashCode();
        h += (h << 5) + this.eventPublisher.hashCode();
        h += (h << 5) + this.mapper.hashCode();
        h += (h << 5) + this.compiler.hashCode();
        h += (h << 5) + this.errorHandler.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DialobClientConfig").omitNullValues().add("store", (Object)this.store).add("cache", (Object)this.cache).add("factory", (Object)this.factory).add("asyncFunctionInvoker", (Object)this.asyncFunctionInvoker).add("eventPublisher", (Object)this.eventPublisher).add("mapper", (Object)this.mapper).add("compiler", (Object)this.compiler).add("errorHandler", (Object)this.errorHandler).toString();
    }

    public static ImmutableDialobClientConfig copyOf(DialobClientConfig instance) {
        if (instance instanceof ImmutableDialobClientConfig) {
            return (ImmutableDialobClientConfig)instance;
        }
        return ImmutableDialobClientConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobClientConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_STORE = 1L;
        private static final long INIT_BIT_CACHE = 2L;
        private static final long INIT_BIT_FACTORY = 4L;
        private static final long INIT_BIT_ASYNC_FUNCTION_INVOKER = 8L;
        private static final long INIT_BIT_EVENT_PUBLISHER = 16L;
        private static final long INIT_BIT_MAPPER = 32L;
        private static final long INIT_BIT_COMPILER = 64L;
        private static final long INIT_BIT_ERROR_HANDLER = 128L;
        private long initBits = 255L;
        @Nullable
        private DialobStore store;
        @Nullable
        private DialobCache cache;
        @Nullable
        private DialobSessionEvalContextFactory factory;
        @Nullable
        private AsyncFunctionInvoker asyncFunctionInvoker;
        @Nullable
        private QuestionnaireEventPublisher eventPublisher;
        @Nullable
        private DialobClient.TypesMapper mapper;
        @Nullable
        private DialobProgramFromFormCompiler compiler;
        @Nullable
        private DialobErrorHandler errorHandler;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobClientConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.store(instance.getStore());
            this.cache(instance.getCache());
            this.factory(instance.getFactory());
            this.asyncFunctionInvoker(instance.getAsyncFunctionInvoker());
            this.eventPublisher(instance.getEventPublisher());
            this.mapper(instance.getMapper());
            this.compiler(instance.getCompiler());
            this.errorHandler(instance.getErrorHandler());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder store(DialobStore store) {
            this.store = Objects.requireNonNull(store, "store");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cache(DialobCache cache) {
            this.cache = Objects.requireNonNull(cache, "cache");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder factory(DialobSessionEvalContextFactory factory) {
            this.factory = Objects.requireNonNull(factory, "factory");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder asyncFunctionInvoker(AsyncFunctionInvoker asyncFunctionInvoker) {
            this.asyncFunctionInvoker = Objects.requireNonNull(asyncFunctionInvoker, "asyncFunctionInvoker");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder eventPublisher(QuestionnaireEventPublisher eventPublisher) {
            this.eventPublisher = Objects.requireNonNull(eventPublisher, "eventPublisher");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mapper(DialobClient.TypesMapper mapper) {
            this.mapper = Objects.requireNonNull(mapper, "mapper");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder compiler(DialobProgramFromFormCompiler compiler) {
            this.compiler = Objects.requireNonNull(compiler, "compiler");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder errorHandler(DialobErrorHandler errorHandler) {
            this.errorHandler = Objects.requireNonNull(errorHandler, "errorHandler");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableDialobClientConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDialobClientConfig(this.store, this.cache, this.factory, this.asyncFunctionInvoker, this.eventPublisher, this.mapper, this.compiler, this.errorHandler);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("store");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("cache");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("factory");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("asyncFunctionInvoker");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("eventPublisher");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("mapper");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("compiler");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("errorHandler");
            }
            return "Cannot build DialobClientConfig, some of required attributes are not set " + attributes;
        }
    }
}

