/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.api.CurrentUserSupplier;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CurrentUserSupplier.CurrentUser", generator="Immutables")
@Immutable
public final class ImmutableCurrentUser
implements CurrentUserSupplier.CurrentUser {
    private final String user;
    private final String email;

    private ImmutableCurrentUser(String user, String email) {
        this.user = user;
        this.email = email;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    public final ImmutableCurrentUser withUser(String value) {
        String newValue = Objects.requireNonNull(value, "user");
        if (this.user.equals(newValue)) {
            return this;
        }
        return new ImmutableCurrentUser(newValue, this.email);
    }

    public final ImmutableCurrentUser withEmail(String value) {
        String newValue = Objects.requireNonNull(value, "email");
        if (this.email.equals(newValue)) {
            return this;
        }
        return new ImmutableCurrentUser(this.user, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCurrentUser && this.equalTo((ImmutableCurrentUser)another);
    }

    private boolean equalTo(ImmutableCurrentUser another) {
        return this.user.equals(another.user) && this.email.equals(another.email);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + this.email.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CurrentUser").omitNullValues().add("user", (Object)this.user).add("email", (Object)this.email).toString();
    }

    public static ImmutableCurrentUser copyOf(CurrentUserSupplier.CurrentUser instance) {
        if (instance instanceof ImmutableCurrentUser) {
            return (ImmutableCurrentUser)instance;
        }
        return ImmutableCurrentUser.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CurrentUserSupplier.CurrentUser", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USER = 1L;
        private static final long INIT_BIT_EMAIL = 2L;
        private long initBits = 3L;
        @Nullable
        private String user;
        @Nullable
        private String email;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CurrentUserSupplier.CurrentUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.user(instance.getUser());
            this.email(instance.getEmail());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder user(String user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder email(String email) {
            this.email = Objects.requireNonNull(email, "email");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableCurrentUser build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCurrentUser(this.user, this.email);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("user");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("email");
            }
            return "Cannot build CurrentUser, some of required attributes are not set " + attributes;
        }
    }
}

