/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobStore;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobStore.CreateStoreEntity", generator="Immutables")
@Immutable
public final class ImmutableCreateStoreEntity
implements DialobStore.CreateStoreEntity {
    private final DialobDocument.DocumentType bodyType;
    @Nullable
    private final String id;
    @Nullable
    private final String version;
    private final String body;

    private ImmutableCreateStoreEntity(DialobDocument.DocumentType bodyType, @Nullable String id, @Nullable String version, String body) {
        this.bodyType = bodyType;
        this.id = id;
        this.version = version;
        this.body = body;
    }

    @Override
    @JsonProperty(value="bodyType")
    public DialobDocument.DocumentType getBodyType() {
        return this.bodyType;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="version")
    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    public final ImmutableCreateStoreEntity withBodyType(DialobDocument.DocumentType value) {
        if (this.bodyType == value) {
            return this;
        }
        DialobDocument.DocumentType newValue = Objects.requireNonNull(value, "bodyType");
        if (this.bodyType.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableCreateStoreEntity(newValue, this.id, this.version, this.body);
    }

    public final ImmutableCreateStoreEntity withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableCreateStoreEntity(this.bodyType, value, this.version, this.body);
    }

    public final ImmutableCreateStoreEntity withVersion(@Nullable String value) {
        if (Objects.equals(this.version, value)) {
            return this;
        }
        return new ImmutableCreateStoreEntity(this.bodyType, this.id, value, this.body);
    }

    public final ImmutableCreateStoreEntity withBody(String value) {
        String newValue = Objects.requireNonNull(value, "body");
        if (this.body.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateStoreEntity(this.bodyType, this.id, this.version, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreateStoreEntity && this.equalTo((ImmutableCreateStoreEntity)another);
    }

    private boolean equalTo(ImmutableCreateStoreEntity another) {
        return this.bodyType.equals((Object)another.bodyType) && Objects.equals(this.id, another.id) && Objects.equals(this.version, another.version) && this.body.equals(another.body);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.bodyType.hashCode();
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.version);
        h += (h << 5) + this.body.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CreateStoreEntity").omitNullValues().add("bodyType", (Object)this.bodyType).add("id", (Object)this.id).add("version", (Object)this.version).add("body", (Object)this.body).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCreateStoreEntity fromJson(Json json) {
        Builder builder = ImmutableCreateStoreEntity.builder();
        if (json.bodyType != null) {
            builder.bodyType(json.bodyType);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        if (json.body != null) {
            builder.body(json.body);
        }
        return builder.build();
    }

    public static ImmutableCreateStoreEntity copyOf(DialobStore.CreateStoreEntity instance) {
        if (instance instanceof ImmutableCreateStoreEntity) {
            return (ImmutableCreateStoreEntity)instance;
        }
        return ImmutableCreateStoreEntity.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobStore.CreateStoreEntity", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BODY_TYPE = 1L;
        private static final long INIT_BIT_BODY = 2L;
        private long initBits = 3L;
        @Nullable
        private DialobDocument.DocumentType bodyType;
        @Nullable
        private String id;
        @Nullable
        private String version;
        @Nullable
        private String body;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobStore.CreateStoreEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobStore.StoreCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DialobStore.StoreCommand instance;
            if (object instanceof DialobStore.CreateStoreEntity) {
                String idValue;
                instance = (DialobStore.CreateStoreEntity)object;
                this.body(instance.getBody());
                String versionValue = instance.getVersion();
                if (versionValue != null) {
                    this.version(versionValue);
                }
                if ((idValue = instance.getId()) != null) {
                    this.id(idValue);
                }
            }
            if (object instanceof DialobStore.StoreCommand) {
                instance = (DialobStore.StoreCommand)object;
                this.bodyType(instance.getBodyType());
            }
        }

        @JsonProperty(value="bodyType")
        @CanIgnoreReturnValue
        public final Builder bodyType(DialobDocument.DocumentType bodyType) {
            this.bodyType = Objects.requireNonNull(bodyType, "bodyType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="version")
        @CanIgnoreReturnValue
        public final Builder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="body")
        @CanIgnoreReturnValue
        public final Builder body(String body) {
            this.body = Objects.requireNonNull(body, "body");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableCreateStoreEntity build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreateStoreEntity(this.bodyType, this.id, this.version, this.body);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("bodyType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("body");
            }
            return "Cannot build CreateStoreEntity, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DialobStore.CreateStoreEntity", generator="Immutables")
    static final class Json
    implements DialobStore.CreateStoreEntity {
        @Nullable
        DialobDocument.DocumentType bodyType;
        @Nullable
        String id;
        @Nullable
        String version;
        @Nullable
        String body;

        Json() {
        }

        @JsonProperty(value="bodyType")
        public void setBodyType(DialobDocument.DocumentType bodyType) {
            this.bodyType = bodyType;
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="version")
        public void setVersion(@Nullable String version) {
            this.version = version;
        }

        @JsonProperty(value="body")
        public void setBody(String body) {
            this.body = body;
        }

        @Override
        public DialobDocument.DocumentType getBodyType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBody() {
            throw new UnsupportedOperationException();
        }
    }
}

