/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.api.DialobComposer;
import io.dialob.client.api.DialobDocument;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobComposer.ComposerState", generator="Immutables")
@Immutable
public final class ImmutableComposerState
implements DialobComposer.ComposerState {
    private final ImmutableMap<String, DialobDocument.FormDocument> forms;
    private final ImmutableMap<String, DialobDocument.FormRevisionDocument> revs;
    private final ImmutableMap<String, DialobDocument.FormReleaseDocument> releases;

    private ImmutableComposerState(ImmutableMap<String, DialobDocument.FormDocument> forms, ImmutableMap<String, DialobDocument.FormRevisionDocument> revs, ImmutableMap<String, DialobDocument.FormReleaseDocument> releases) {
        this.forms = forms;
        this.revs = revs;
        this.releases = releases;
    }

    @JsonProperty(value="forms")
    public ImmutableMap<String, DialobDocument.FormDocument> getForms() {
        return this.forms;
    }

    @JsonProperty(value="revs")
    public ImmutableMap<String, DialobDocument.FormRevisionDocument> getRevs() {
        return this.revs;
    }

    @JsonProperty(value="releases")
    public ImmutableMap<String, DialobDocument.FormReleaseDocument> getReleases() {
        return this.releases;
    }

    public final ImmutableComposerState withForms(Map<String, ? extends DialobDocument.FormDocument> entries) {
        if (this.forms == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableComposerState((ImmutableMap<String, DialobDocument.FormDocument>)newValue, this.revs, this.releases);
    }

    public final ImmutableComposerState withRevs(Map<String, ? extends DialobDocument.FormRevisionDocument> entries) {
        if (this.revs == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableComposerState(this.forms, (ImmutableMap<String, DialobDocument.FormRevisionDocument>)newValue, this.releases);
    }

    public final ImmutableComposerState withReleases(Map<String, ? extends DialobDocument.FormReleaseDocument> entries) {
        if (this.releases == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableComposerState(this.forms, this.revs, (ImmutableMap<String, DialobDocument.FormReleaseDocument>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableComposerState && this.equalTo((ImmutableComposerState)another);
    }

    private boolean equalTo(ImmutableComposerState another) {
        return this.forms.equals(another.forms) && this.revs.equals(another.revs) && this.releases.equals(another.releases);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.forms.hashCode();
        h += (h << 5) + this.revs.hashCode();
        h += (h << 5) + this.releases.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ComposerState").omitNullValues().add("forms", this.forms).add("revs", this.revs).add("releases", this.releases).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableComposerState fromJson(Json json) {
        Builder builder = ImmutableComposerState.builder();
        if (json.forms != null) {
            builder.putAllForms(json.forms);
        }
        if (json.revs != null) {
            builder.putAllRevs(json.revs);
        }
        if (json.releases != null) {
            builder.putAllReleases(json.releases);
        }
        return builder.build();
    }

    public static ImmutableComposerState copyOf(DialobComposer.ComposerState instance) {
        if (instance instanceof ImmutableComposerState) {
            return (ImmutableComposerState)instance;
        }
        return ImmutableComposerState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobComposer.ComposerState", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableMap.Builder<String, DialobDocument.FormDocument> forms = ImmutableMap.builder();
        private ImmutableMap.Builder<String, DialobDocument.FormRevisionDocument> revs = ImmutableMap.builder();
        private ImmutableMap.Builder<String, DialobDocument.FormReleaseDocument> releases = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobComposer.ComposerState instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllForms(instance.getForms());
            this.putAllRevs(instance.getRevs());
            this.putAllReleases(instance.getReleases());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putForms(String key, DialobDocument.FormDocument value) {
            this.forms.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putForms(Map.Entry<String, ? extends DialobDocument.FormDocument> entry) {
            this.forms.put(entry);
            return this;
        }

        @JsonProperty(value="forms")
        @CanIgnoreReturnValue
        public final Builder forms(Map<String, ? extends DialobDocument.FormDocument> entries) {
            this.forms = ImmutableMap.builder();
            return this.putAllForms(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllForms(Map<String, ? extends DialobDocument.FormDocument> entries) {
            this.forms.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putRevs(String key, DialobDocument.FormRevisionDocument value) {
            this.revs.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putRevs(Map.Entry<String, ? extends DialobDocument.FormRevisionDocument> entry) {
            this.revs.put(entry);
            return this;
        }

        @JsonProperty(value="revs")
        @CanIgnoreReturnValue
        public final Builder revs(Map<String, ? extends DialobDocument.FormRevisionDocument> entries) {
            this.revs = ImmutableMap.builder();
            return this.putAllRevs(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllRevs(Map<String, ? extends DialobDocument.FormRevisionDocument> entries) {
            this.revs.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putReleases(String key, DialobDocument.FormReleaseDocument value) {
            this.releases.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putReleases(Map.Entry<String, ? extends DialobDocument.FormReleaseDocument> entry) {
            this.releases.put(entry);
            return this;
        }

        @JsonProperty(value="releases")
        @CanIgnoreReturnValue
        public final Builder releases(Map<String, ? extends DialobDocument.FormReleaseDocument> entries) {
            this.releases = ImmutableMap.builder();
            return this.putAllReleases(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllReleases(Map<String, ? extends DialobDocument.FormReleaseDocument> entries) {
            this.releases.putAll(entries);
            return this;
        }

        public ImmutableComposerState build() {
            return new ImmutableComposerState((ImmutableMap<String, DialobDocument.FormDocument>)this.forms.build(), (ImmutableMap<String, DialobDocument.FormRevisionDocument>)this.revs.build(), (ImmutableMap<String, DialobDocument.FormReleaseDocument>)this.releases.build());
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DialobComposer.ComposerState", generator="Immutables")
    static final class Json
    implements DialobComposer.ComposerState {
        @Nullable
        Map<String, DialobDocument.FormDocument> forms = ImmutableMap.of();
        @Nullable
        Map<String, DialobDocument.FormRevisionDocument> revs = ImmutableMap.of();
        @Nullable
        Map<String, DialobDocument.FormReleaseDocument> releases = ImmutableMap.of();

        Json() {
        }

        @JsonProperty(value="forms")
        public void setForms(Map<String, DialobDocument.FormDocument> forms) {
            this.forms = forms;
        }

        @JsonProperty(value="revs")
        public void setRevs(Map<String, DialobDocument.FormRevisionDocument> revs) {
            this.revs = revs;
        }

        @JsonProperty(value="releases")
        public void setReleases(Map<String, DialobDocument.FormReleaseDocument> releases) {
            this.releases = releases;
        }

        @Override
        public Map<String, DialobDocument.FormDocument> getForms() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, DialobDocument.FormRevisionDocument> getRevs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, DialobDocument.FormReleaseDocument> getReleases() {
            throw new UnsupportedOperationException();
        }
    }
}

