/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.api.DialobComposer;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobComposer.ComposerReleaseState", generator="Immutables")
@Immutable
public final class ImmutableComposerReleaseState
implements DialobComposer.ComposerReleaseState {
    private final String id;
    private final String name;
    private final String description;
    private final String hash;
    private final String content;

    private ImmutableComposerReleaseState(String id, String name, String description, String hash, String content) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.hash = hash;
        this.content = content;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="hash")
    public String getHash() {
        return this.hash;
    }

    @Override
    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    public final ImmutableComposerReleaseState withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableComposerReleaseState(newValue, this.name, this.description, this.hash, this.content);
    }

    public final ImmutableComposerReleaseState withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableComposerReleaseState(this.id, newValue, this.description, this.hash, this.content);
    }

    public final ImmutableComposerReleaseState withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableComposerReleaseState(this.id, this.name, newValue, this.hash, this.content);
    }

    public final ImmutableComposerReleaseState withHash(String value) {
        String newValue = Objects.requireNonNull(value, "hash");
        if (this.hash.equals(newValue)) {
            return this;
        }
        return new ImmutableComposerReleaseState(this.id, this.name, this.description, newValue, this.content);
    }

    public final ImmutableComposerReleaseState withContent(String value) {
        String newValue = Objects.requireNonNull(value, "content");
        if (this.content.equals(newValue)) {
            return this;
        }
        return new ImmutableComposerReleaseState(this.id, this.name, this.description, this.hash, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableComposerReleaseState && this.equalTo((ImmutableComposerReleaseState)another);
    }

    private boolean equalTo(ImmutableComposerReleaseState another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.description.equals(another.description) && this.hash.equals(another.hash) && this.content.equals(another.content);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + this.content.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ComposerReleaseState").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description).add("hash", (Object)this.hash).add("content", (Object)this.content).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableComposerReleaseState fromJson(Json json) {
        Builder builder = ImmutableComposerReleaseState.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        return builder.build();
    }

    public static ImmutableComposerReleaseState copyOf(DialobComposer.ComposerReleaseState instance) {
        if (instance instanceof ImmutableComposerReleaseState) {
            return (ImmutableComposerReleaseState)instance;
        }
        return ImmutableComposerReleaseState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobComposer.ComposerReleaseState", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_DESCRIPTION = 4L;
        private static final long INIT_BIT_HASH = 8L;
        private static final long INIT_BIT_CONTENT = 16L;
        private long initBits = 31L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private String hash;
        @Nullable
        private String content;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobComposer.ComposerReleaseState instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.name(instance.getName());
            this.description(instance.getDescription());
            this.hash(instance.getHash());
            this.content(instance.getContent());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="hash")
        @CanIgnoreReturnValue
        public final Builder hash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="content")
        @CanIgnoreReturnValue
        public final Builder content(String content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableComposerReleaseState build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableComposerReleaseState(this.id, this.name, this.description, this.hash, this.content);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("content");
            }
            return "Cannot build ComposerReleaseState, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DialobComposer.ComposerReleaseState", generator="Immutables")
    static final class Json
    implements DialobComposer.ComposerReleaseState {
        @Nullable
        String id;
        @Nullable
        String name;
        @Nullable
        String description;
        @Nullable
        String hash;
        @Nullable
        String content;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="hash")
        public void setHash(String hash) {
            this.hash = hash;
        }

        @JsonProperty(value="content")
        public void setContent(String content) {
            this.content = content;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getContent() {
            throw new UnsupportedOperationException();
        }
    }
}

