/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.api.DialobComposer;
import io.dialob.client.api.DialobDocument;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobComposer.ComposerDocumentState", generator="Immutables")
@Immutable
public final class ImmutableComposerDocumentState
implements DialobComposer.ComposerDocumentState {
    private final DialobDocument.FormDocument form;
    private final DialobDocument.FormRevisionDocument revision;

    private ImmutableComposerDocumentState(DialobDocument.FormDocument form, DialobDocument.FormRevisionDocument revision) {
        this.form = form;
        this.revision = revision;
    }

    @Override
    @JsonProperty(value="form")
    public DialobDocument.FormDocument getForm() {
        return this.form;
    }

    @Override
    @JsonProperty(value="revision")
    public DialobDocument.FormRevisionDocument getRevision() {
        return this.revision;
    }

    public final ImmutableComposerDocumentState withForm(DialobDocument.FormDocument value) {
        if (this.form == value) {
            return this;
        }
        DialobDocument.FormDocument newValue = Objects.requireNonNull(value, "form");
        return new ImmutableComposerDocumentState(newValue, this.revision);
    }

    public final ImmutableComposerDocumentState withRevision(DialobDocument.FormRevisionDocument value) {
        if (this.revision == value) {
            return this;
        }
        DialobDocument.FormRevisionDocument newValue = Objects.requireNonNull(value, "revision");
        return new ImmutableComposerDocumentState(this.form, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableComposerDocumentState && this.equalTo((ImmutableComposerDocumentState)another);
    }

    private boolean equalTo(ImmutableComposerDocumentState another) {
        return this.form.equals(another.form) && this.revision.equals(another.revision);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.form.hashCode();
        h += (h << 5) + this.revision.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ComposerDocumentState").omitNullValues().add("form", (Object)this.form).add("revision", (Object)this.revision).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableComposerDocumentState fromJson(Json json) {
        Builder builder = ImmutableComposerDocumentState.builder();
        if (json.form != null) {
            builder.form(json.form);
        }
        if (json.revision != null) {
            builder.revision(json.revision);
        }
        return builder.build();
    }

    public static ImmutableComposerDocumentState copyOf(DialobComposer.ComposerDocumentState instance) {
        if (instance instanceof ImmutableComposerDocumentState) {
            return (ImmutableComposerDocumentState)instance;
        }
        return ImmutableComposerDocumentState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobComposer.ComposerDocumentState", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FORM = 1L;
        private static final long INIT_BIT_REVISION = 2L;
        private long initBits = 3L;
        @Nullable
        private DialobDocument.FormDocument form;
        @Nullable
        private DialobDocument.FormRevisionDocument revision;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobComposer.ComposerDocumentState instance) {
            Objects.requireNonNull(instance, "instance");
            this.form(instance.getForm());
            this.revision(instance.getRevision());
            return this;
        }

        @JsonProperty(value="form")
        @CanIgnoreReturnValue
        public final Builder form(DialobDocument.FormDocument form) {
            this.form = Objects.requireNonNull(form, "form");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="revision")
        @CanIgnoreReturnValue
        public final Builder revision(DialobDocument.FormRevisionDocument revision) {
            this.revision = Objects.requireNonNull(revision, "revision");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableComposerDocumentState build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableComposerDocumentState(this.form, this.revision);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("form");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("revision");
            }
            return "Cannot build ComposerDocumentState, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DialobComposer.ComposerDocumentState", generator="Immutables")
    static final class Json
    implements DialobComposer.ComposerDocumentState {
        @Nullable
        DialobDocument.FormDocument form;
        @Nullable
        DialobDocument.FormRevisionDocument revision;

        Json() {
        }

        @JsonProperty(value="form")
        public void setForm(DialobDocument.FormDocument form) {
            this.form = form;
        }

        @JsonProperty(value="revision")
        public void setRevision(DialobDocument.FormRevisionDocument revision) {
            this.revision = revision;
        }

        @Override
        public DialobDocument.FormDocument getForm() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DialobDocument.FormRevisionDocument getRevision() {
            throw new UnsupportedOperationException();
        }
    }
}

