/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.client.api.DialobCache;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobStore;
import io.dialob.program.DialobProgram;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialobCache.CacheEntry", generator="Immutables")
@Immutable
public final class ImmutableCacheEntry
implements DialobCache.CacheEntry {
    private final String id;
    private final String rev;
    private final DialobStore.StoreEntity source;
    private final DialobDocument ast;
    @Nullable
    private final DialobProgram program;

    private ImmutableCacheEntry(String id, String rev, DialobStore.StoreEntity source, DialobDocument ast, @Nullable DialobProgram program) {
        this.id = id;
        this.rev = rev;
        this.source = source;
        this.ast = ast;
        this.program = program;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getRev() {
        return this.rev;
    }

    @Override
    public DialobStore.StoreEntity getSource() {
        return this.source;
    }

    @Override
    public DialobDocument getAst() {
        return this.ast;
    }

    @Override
    public Optional<DialobProgram> getProgram() {
        return Optional.ofNullable(this.program);
    }

    public final ImmutableCacheEntry withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableCacheEntry(newValue, this.rev, this.source, this.ast, this.program);
    }

    public final ImmutableCacheEntry withRev(String value) {
        String newValue = Objects.requireNonNull(value, "rev");
        if (this.rev.equals(newValue)) {
            return this;
        }
        return new ImmutableCacheEntry(this.id, newValue, this.source, this.ast, this.program);
    }

    public final ImmutableCacheEntry withSource(DialobStore.StoreEntity value) {
        if (this.source == value) {
            return this;
        }
        DialobStore.StoreEntity newValue = Objects.requireNonNull(value, "source");
        return new ImmutableCacheEntry(this.id, this.rev, newValue, this.ast, this.program);
    }

    public final ImmutableCacheEntry withAst(DialobDocument value) {
        if (this.ast == value) {
            return this;
        }
        DialobDocument newValue = Objects.requireNonNull(value, "ast");
        return new ImmutableCacheEntry(this.id, this.rev, this.source, newValue, this.program);
    }

    public final ImmutableCacheEntry withProgram(DialobProgram value) {
        DialobProgram newValue = Objects.requireNonNull(value, "program");
        if (this.program == newValue) {
            return this;
        }
        return new ImmutableCacheEntry(this.id, this.rev, this.source, this.ast, newValue);
    }

    public final ImmutableCacheEntry withProgram(Optional<? extends DialobProgram> optional) {
        DialobProgram value = optional.orElse(null);
        if (this.program == value) {
            return this;
        }
        return new ImmutableCacheEntry(this.id, this.rev, this.source, this.ast, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCacheEntry && this.equalTo((ImmutableCacheEntry)another);
    }

    private boolean equalTo(ImmutableCacheEntry another) {
        return this.id.equals(another.id) && this.rev.equals(another.rev) && this.source.equals(another.source) && this.ast.equals(another.ast) && Objects.equals(this.program, another.program);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.rev.hashCode();
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + this.ast.hashCode();
        h += (h << 5) + Objects.hashCode(this.program);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CacheEntry").omitNullValues().add("id", (Object)this.id).add("rev", (Object)this.rev).add("source", (Object)this.source).add("ast", (Object)this.ast).add("program", (Object)this.program).toString();
    }

    public static ImmutableCacheEntry copyOf(DialobCache.CacheEntry instance) {
        if (instance instanceof ImmutableCacheEntry) {
            return (ImmutableCacheEntry)instance;
        }
        return ImmutableCacheEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DialobCache.CacheEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_REV = 2L;
        private static final long INIT_BIT_SOURCE = 4L;
        private static final long INIT_BIT_AST = 8L;
        private long initBits = 15L;
        @Nullable
        private String id;
        @Nullable
        private String rev;
        @Nullable
        private DialobStore.StoreEntity source;
        @Nullable
        private DialobDocument ast;
        @Nullable
        private DialobProgram program;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DialobCache.CacheEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.rev(instance.getRev());
            this.source(instance.getSource());
            this.ast(instance.getAst());
            Optional<DialobProgram> programOptional = instance.getProgram();
            if (programOptional.isPresent()) {
                this.program(programOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rev(String rev) {
            this.rev = Objects.requireNonNull(rev, "rev");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder source(DialobStore.StoreEntity source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ast(DialobDocument ast) {
            this.ast = Objects.requireNonNull(ast, "ast");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder program(DialobProgram program) {
            this.program = Objects.requireNonNull(program, "program");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder program(Optional<? extends DialobProgram> program) {
            this.program = program.orElse(null);
            return this;
        }

        public ImmutableCacheEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCacheEntry(this.id, this.rev, this.source, this.ast, this.program);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("rev");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("source");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("ast");
            }
            return "Cannot build CacheEntry, some of required attributes are not set " + attributes;
        }
    }
}

