/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.ImmutableCreateStoreEntity;
import io.dialob.client.api.ImmutableDeleteStoreEntity;
import io.dialob.client.api.ImmutableStoreEntity;
import io.dialob.client.api.ImmutableStoreExceptionMsg;
import io.dialob.client.api.ImmutableStoreState;
import io.dialob.client.api.ImmutableUpdateStoreEntity;
import io.smallrye.mutiny.Uni;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.immutables.value.Value;

public interface DialobStore {
    public Uni<StoreEntity> create(CreateStoreEntity var1);

    public Uni<StoreEntity> update(UpdateStoreEntity var1);

    public Uni<StoreEntity> delete(DeleteStoreEntity var1);

    public Uni<List<StoreEntity>> batch(List<StoreCommand> var1);

    public QueryBuilder query();

    public String getRepoName();

    public String getHeadName();

    public StoreRepoBuilder repo();

    @Value.Immutable
    public static interface DialobCreds {
        public String getUser();

        public String getEmail();
    }

    @FunctionalInterface
    public static interface DialobCredsSupplier
    extends Supplier<DialobCreds> {
    }

    @JsonSerialize(as=ImmutableStoreExceptionMsg.class)
    @Value.Immutable
    public static interface StoreExceptionMsg {
        public String getId();

        public String getValue();

        public List<String> getArgs();
    }

    @JsonSerialize(as=ImmutableDeleteStoreEntity.class)
    @JsonDeserialize(as=ImmutableDeleteStoreEntity.class)
    @Value.Immutable
    public static interface DeleteStoreEntity
    extends StoreCommand {
        public String getId();

        public String getVersion();
    }

    @JsonSerialize(as=ImmutableCreateStoreEntity.class)
    @JsonDeserialize(as=ImmutableCreateStoreEntity.class)
    @Value.Immutable
    public static interface CreateStoreEntity
    extends StoreCommand {
        @Nullable
        public String getId();

        @Nullable
        public String getVersion();

        public String getBody();
    }

    @JsonSerialize(as=ImmutableUpdateStoreEntity.class)
    @JsonDeserialize(as=ImmutableUpdateStoreEntity.class)
    @Value.Immutable
    public static interface UpdateStoreEntity
    extends StoreCommand {
        public String getId();

        public String getVersion();

        public String getBody();
    }

    @JsonSerialize(as=ImmutableUpdateStoreEntity.class)
    @JsonDeserialize(as=ImmutableUpdateStoreEntity.class)
    @Value.Immutable
    public static interface EmptyCommand
    extends StoreCommand {
        public String getId();

        public String getDescription();
    }

    public static interface StoreCommand
    extends Serializable {
        public DialobDocument.DocumentType getBodyType();
    }

    @JsonSerialize(as=ImmutableStoreEntity.class)
    @JsonDeserialize(as=ImmutableStoreEntity.class)
    @Value.Immutable
    public static interface StoreEntity
    extends Serializable {
        public String getId();

        public String getVersion();

        public DialobDocument.DocumentType getBodyType();

        public String getBody();
    }

    @JsonSerialize(as=ImmutableStoreState.class)
    @JsonDeserialize(as=ImmutableStoreState.class)
    @Value.Immutable
    public static interface StoreState {
        public Map<String, StoreEntity> getRevs();

        public Map<String, StoreEntity> getForms();

        public Map<String, StoreEntity> getTags();
    }

    public static interface QueryBuilder {
        public Uni<StoreState> get();

        public Uni<StoreEntity> get(String var1);
    }

    public static interface StoreRepoBuilder {
        public StoreRepoBuilder repoName(String var1);

        public StoreRepoBuilder headName(String var1);

        public Uni<DialobStore> create();

        public DialobStore build();

        public Uni<Boolean> createIfNot();
    }
}

