/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.dialob.api.form.Form;
import io.dialob.client.api.ImmutableFormDocument;
import io.dialob.client.api.ImmutableFormReleaseDocument;
import io.dialob.client.api.ImmutableFormReleaseValueDocument;
import io.dialob.client.api.ImmutableFormRevisionDocument;
import io.dialob.client.api.ImmutableFormRevisionEntryDocument;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Nullable;
import org.immutables.value.Value;

public interface DialobDocument
extends Serializable {
    @Nullable
    public String getId();

    @Nullable
    public String getVersion();

    @Nullable
    public String getDescription();

    public DocumentType getType();

    public String getName();

    public LocalDateTime getCreated();

    @JsonSerialize(as=ImmutableFormReleaseValueDocument.class)
    @JsonDeserialize(as=ImmutableFormReleaseValueDocument.class)
    @Value.Immutable
    public static interface FormReleaseValueDocument
    extends Serializable {
        public String getHash();

        public DocumentType getBodyType();

        @Nullable
        public String getDescription();

        public String getCommands();
    }

    @JsonSerialize(as=ImmutableFormRevisionEntryDocument.class)
    @JsonDeserialize(as=ImmutableFormRevisionEntryDocument.class)
    @Value.Immutable
    public static interface FormRevisionEntryDocument
    extends Serializable {
        @Nullable
        public String getId();

        public String getRevisionName();

        public String getFormId();

        public LocalDateTime getCreated();

        public LocalDateTime getUpdated();

        @Nullable
        public String getDescription();
    }

    @JsonSerialize(as=ImmutableFormReleaseDocument.class)
    @JsonDeserialize(as=ImmutableFormReleaseDocument.class)
    @Value.Immutable
    public static interface FormReleaseDocument
    extends DialobDocument {
        @Override
        public LocalDateTime getCreated();

        public List<FormReleaseValueDocument> getValues();

        @Override
        @Value.Default
        default public DocumentType getType() {
            return DocumentType.RELEASE;
        }
    }

    @JsonSerialize(as=ImmutableFormDocument.class)
    @JsonDeserialize(as=ImmutableFormDocument.class)
    @Value.Immutable
    public static interface FormDocument
    extends DialobDocument {
        public Form getData();

        public LocalDateTime getUpdated();

        @Override
        @Value.Default
        default public DocumentType getType() {
            return DocumentType.FORM;
        }

        @Override
        @Value.Default
        default public String getName() {
            return this.getData().getName();
        }
    }

    @JsonSerialize(as=ImmutableFormRevisionDocument.class)
    @JsonDeserialize(as=ImmutableFormRevisionDocument.class)
    @Value.Immutable
    public static interface FormRevisionDocument
    extends DialobDocument {
        public String getHead();

        public LocalDateTime getUpdated();

        public List<FormRevisionEntryDocument> getEntries();

        @Override
        @Value.Default
        default public DocumentType getType() {
            return DocumentType.FORM_REV;
        }
    }

    public static enum DocumentType {
        FORM,
        FORM_REV,
        RELEASE;

    }
}

