/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.dialob.api.form.Form;
import io.dialob.api.form.FormValidationError;
import io.dialob.api.proto.Actions;
import io.dialob.api.proto.ValueSet;
import io.dialob.api.questionnaire.Answer;
import io.dialob.api.questionnaire.ContextValue;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.client.api.DialobClientConfig;
import io.dialob.client.api.DialobDocument;
import io.dialob.client.api.DialobErrorHandler;
import io.dialob.client.api.DialobStore;
import io.dialob.client.api.QuestionnaireSession;
import io.dialob.program.DialobProgram;
import io.smallrye.mutiny.Uni;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.immutables.value.Value;

public interface DialobClient {
    public ProgramBuilder program();

    public QuestionnaireExecutorBuilder executor(ProgramEnvir var1);

    public EnvirBuilder envir();

    public DialobClientConfig getConfig();

    public DialobStore store();

    public RepoBuilder repo();

    public static interface TypesMapper {
        public String toString(InputStream var1);

        public Questionnaire readQuestionnaire(InputStream var1);

        public Form readForm(String var1);

        public DialobDocument.FormReleaseDocument readReleaseDoc(String var1);

        public DialobDocument.FormDocument readFormDoc(String var1);

        public DialobDocument.FormRevisionDocument readFormRevDoc(String var1);

        public String toJson(Object var1);

        public DialobDocument.FormReleaseDocument toFormReleaseDoc(DialobStore.StoreEntity var1);

        public DialobDocument.FormRevisionDocument toFormRevDoc(DialobStore.StoreEntity var1);

        public DialobDocument.FormDocument toFormDoc(DialobStore.StoreEntity var1);

        public String toStoreBody(DialobDocument.FormReleaseDocument var1);

        public String toStoreBody(DialobDocument.FormRevisionDocument var1);

        public String toStoreBody(DialobDocument.FormDocument var1);
    }

    public static enum ProgramStatus {
        UP,
        AST_ERROR,
        PROGRAM_ERROR,
        DEPENDENCY_ERROR;

    }

    @Value.Immutable
    public static interface ProgramMessage {
        public String getId();

        @Nullable
        public String getMsg();

        @Nullable
        public FormValidationError getSrc();

        @JsonIgnore
        @Nullable
        public Exception getException();
    }

    @Value.Immutable
    public static interface ProgramWrapper
    extends ProgramEnvirValue<DialobDocument.FormDocument> {
        public String getId();

        public ProgramStatus getStatus();

        public List<ProgramMessage> getErrors();

        @JsonIgnore
        public Optional<DialobProgram> getProgram();
    }

    @Value.Immutable
    public static interface ReleaseWrapper
    extends ProgramEnvirValue<DialobDocument.FormReleaseDocument> {
    }

    @Value.Immutable
    public static interface RevisionWrapper
    extends ProgramEnvirValue<DialobDocument.FormRevisionDocument> {
    }

    public static interface ProgramEnvirValue<T extends DialobDocument>
    extends Serializable {
        public DialobStore.StoreEntity getSource();

        @JsonIgnore
        public T getDocument();
    }

    public static interface ProgramEnvir {
        public ProgramWrapper findByFormId(String var1) throws DialobErrorHandler.DocumentNotFoundException;

        public ProgramWrapper findByFormIdAndRev(String var1, String var2) throws DialobErrorHandler.DocumentNotFoundException;

        public List<ProgramWrapper> findAll();

        public Map<String, ProgramEnvirValue<?>> getValues();
    }

    public static interface RepoBuilder {
        public RepoBuilder repoName(String var1);

        public RepoBuilder headName(String var1);

        public Uni<DialobClient> create();

        public DialobClient build();
    }

    public static interface EnvirCommandFormatBuilder {
        public EnvirCommandFormatBuilder id(String var1);

        public EnvirCommandFormatBuilder version(String var1);

        public EnvirCommandFormatBuilder cachless();

        public EnvirCommandFormatBuilder rev(String var1);

        public EnvirCommandFormatBuilder form(String var1);

        public EnvirCommandFormatBuilder form(InputStream var1);

        public EnvirCommandFormatBuilder rev(DialobStore.StoreEntity var1);

        public EnvirCommandFormatBuilder form(DialobStore.StoreEntity var1);

        public EnvirCommandFormatBuilder release(DialobStore.StoreEntity var1);

        public EnvirCommandFormatBuilder form(Form var1);

        public EnvirBuilder build();
    }

    public static interface EnvirBuilder {
        public EnvirBuilder from(ProgramEnvir var1);

        public EnvirBuilder from(DialobStore.StoreState var1);

        public EnvirCommandFormatBuilder addCommand();

        public ProgramEnvir build();
    }

    public static interface ProgramBuilder {
        public ProgramBuilder form(DialobDocument.FormDocument var1);

        public DialobProgram build();
    }

    @Value.Immutable
    public static interface ExecutorBody {
        public Actions getActions();

        public Questionnaire getQuestionnaire();
    }

    public static interface QuestionnaireExecutor {
        public QuestionnaireExecutor createOnly(boolean var1);

        public QuestionnaireExecutor actions(Actions var1);

        public Actions execute();

        public ExecutorBody executeAndGetBody();

        public QuestionnaireSession toSession();
    }

    public static interface QuestionnaireInit {
        public QuestionnaireInit activeItem(String var1);

        public QuestionnaireInit status(Questionnaire.Metadata.Status var1);

        public QuestionnaireInit valueSets(List<ValueSet> var1);

        public QuestionnaireInit questionnaire(Questionnaire var1);

        public QuestionnaireInit submitUrl(String var1);

        public QuestionnaireInit id(String var1);

        public QuestionnaireInit rev(String var1);

        public QuestionnaireInit creator(String var1);

        public QuestionnaireInit owner(String var1);

        public QuestionnaireInit language(String var1);

        public QuestionnaireInit additionalProperties(Map<String, Object> var1);

        public QuestionnaireInit contextValues(List<ContextValue> var1);

        public QuestionnaireInit answers(List<Answer> var1);
    }

    public static interface QuestionnaireExecutorBuilder {
        public QuestionnaireExecutor create(String var1, String var2, Consumer<QuestionnaireInit> var3) throws DialobErrorHandler.DocumentNotFoundException;

        public QuestionnaireExecutor create(String var1, Consumer<QuestionnaireInit> var2) throws DialobErrorHandler.DocumentNotFoundException;

        public QuestionnaireExecutor restore(Questionnaire var1) throws DialobErrorHandler.DocumentNotFoundException;
    }
}

