package io.dialob.client.spi.store;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.client.api.DialobStore;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobStoreConfig.EntityState}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEntityState.builder()}.
 */
@Generated(from = "DialobStoreConfig.EntityState", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableEntityState implements DialobStoreConfig.EntityState {
  private final ObjectsActions.ObjectsResult<ObjectsActions.BlobObject> src;
  private final DialobStore.StoreEntity entity;

  private ImmutableEntityState(
      ObjectsActions.ObjectsResult<ObjectsActions.BlobObject> src,
      DialobStore.StoreEntity entity) {
    this.src = src;
    this.entity = entity;
  }

  /**
   * @return The value of the {@code src} attribute
   */
  @Override
  public ObjectsActions.ObjectsResult<ObjectsActions.BlobObject> getSrc() {
    return src;
  }

  /**
   * @return The value of the {@code entity} attribute
   */
  @Override
  public DialobStore.StoreEntity getEntity() {
    return entity;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStoreConfig.EntityState#getSrc() src} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for src
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEntityState withSrc(ObjectsActions.ObjectsResult<ObjectsActions.BlobObject> value) {
    if (this.src == value) return this;
    ObjectsActions.ObjectsResult<ObjectsActions.BlobObject> newValue = Objects.requireNonNull(value, "src");
    return new ImmutableEntityState(newValue, this.entity);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStoreConfig.EntityState#getEntity() entity} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for entity
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEntityState withEntity(DialobStore.StoreEntity value) {
    if (this.entity == value) return this;
    DialobStore.StoreEntity newValue = Objects.requireNonNull(value, "entity");
    return new ImmutableEntityState(this.src, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEntityState} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEntityState
        && equalTo((ImmutableEntityState) another);
  }

  private boolean equalTo(ImmutableEntityState another) {
    return src.equals(another.src)
        && entity.equals(another.entity);
  }

  /**
   * Computes a hash code from attributes: {@code src}, {@code entity}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + src.hashCode();
    h += (h << 5) + entity.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EntityState} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("EntityState")
        .omitNullValues()
        .add("src", src)
        .add("entity", entity)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link DialobStoreConfig.EntityState} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EntityState instance
   */
  public static ImmutableEntityState copyOf(DialobStoreConfig.EntityState instance) {
    if (instance instanceof ImmutableEntityState) {
      return (ImmutableEntityState) instance;
    }
    return ImmutableEntityState.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEntityState ImmutableEntityState}.
   * <pre>
   * ImmutableEntityState.builder()
   *    .src(io.resys.thena.docdb.api.actions.ObjectsActions.ObjectsResult&amp;lt;io.resys.thena.docdb.api.actions.ObjectsActions.BlobObject&amp;gt;) // required {@link DialobStoreConfig.EntityState#getSrc() src}
   *    .entity(io.dialob.client.api.DialobStore.StoreEntity) // required {@link DialobStoreConfig.EntityState#getEntity() entity}
   *    .build();
   * </pre>
   * @return A new ImmutableEntityState builder
   */
  public static ImmutableEntityState.Builder builder() {
    return new ImmutableEntityState.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEntityState ImmutableEntityState}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobStoreConfig.EntityState", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SRC = 0x1L;
    private static final long INIT_BIT_ENTITY = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ObjectsActions.ObjectsResult<ObjectsActions.BlobObject> src;
    private @Nullable DialobStore.StoreEntity entity;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EntityState} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobStoreConfig.EntityState instance) {
      Objects.requireNonNull(instance, "instance");
      src(instance.getSrc());
      entity(instance.getEntity());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStoreConfig.EntityState#getSrc() src} attribute.
     * @param src The value for src 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder src(ObjectsActions.ObjectsResult<ObjectsActions.BlobObject> src) {
      this.src = Objects.requireNonNull(src, "src");
      initBits &= ~INIT_BIT_SRC;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStoreConfig.EntityState#getEntity() entity} attribute.
     * @param entity The value for entity 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder entity(DialobStore.StoreEntity entity) {
      this.entity = Objects.requireNonNull(entity, "entity");
      initBits &= ~INIT_BIT_ENTITY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEntityState ImmutableEntityState}.
     * @return An immutable instance of EntityState
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEntityState build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEntityState(src, entity);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SRC) != 0) attributes.add("src");
      if ((initBits & INIT_BIT_ENTITY) != 0) attributes.add("entity");
      return "Cannot build EntityState, some of required attributes are not set " + attributes;
    }
  }
}
