package io.dialob.client.spi.function;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.rule.parser.api.ValueType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ConfiguredFunction}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConfiguredFunction.builder()}.
 */
@Generated(from = "ConfiguredFunction", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableConfiguredFunction implements ConfiguredFunction {
  private final String functionName;
  private final String staticMethodName;
  private final ValueType returnType;
  private final ImmutableList<ValueType> argumentValueTypes;
  private final Predicate<ValueType[]> argumentMatcher;
  private final Class<?>[] argumentTypes;
  private final Class functionImplementationClass;
  private final boolean isAsync;

  private ImmutableConfiguredFunction(ImmutableConfiguredFunction.Builder builder) {
    this.functionName = builder.functionName;
    this.staticMethodName = builder.staticMethodName;
    this.returnType = builder.returnType;
    this.argumentValueTypes = builder.argumentValueTypes.build();
    this.argumentTypes = builder.argumentTypes;
    this.functionImplementationClass = builder.functionImplementationClass;
    this.isAsync = builder.isAsync;
    this.argumentMatcher = builder.argumentMatcher != null
        ? builder.argumentMatcher
        : Objects.requireNonNull(ConfiguredFunction.super.getArgumentMatcher(), "argumentMatcher");
  }

  private ImmutableConfiguredFunction(
      String functionName,
      String staticMethodName,
      ValueType returnType,
      ImmutableList<ValueType> argumentValueTypes,
      Predicate<ValueType[]> argumentMatcher,
      Class<?>[] argumentTypes,
      Class functionImplementationClass,
      boolean isAsync) {
    this.functionName = functionName;
    this.staticMethodName = staticMethodName;
    this.returnType = returnType;
    this.argumentValueTypes = argumentValueTypes;
    this.argumentMatcher = argumentMatcher;
    this.argumentTypes = argumentTypes;
    this.functionImplementationClass = functionImplementationClass;
    this.isAsync = isAsync;
  }

  /**
   * @return The value of the {@code functionName} attribute
   */
  @Override
  public String getFunctionName() {
    return functionName;
  }

  /**
   * @return The value of the {@code staticMethodName} attribute
   */
  @Override
  public String getStaticMethodName() {
    return staticMethodName;
  }

  /**
   * @return The value of the {@code returnType} attribute
   */
  @Override
  public ValueType getReturnType() {
    return returnType;
  }

  /**
   * @return The value of the {@code argumentValueTypes} attribute
   */
  @Override
  public ImmutableList<ValueType> getArgumentValueTypes() {
    return argumentValueTypes;
  }

  /**
   * @return The value of the {@code argumentMatcher} attribute
   */
  @Override
  public Predicate<ValueType[]> getArgumentMatcher() {
    return argumentMatcher;
  }

  /**
   * @return A cloned {@code argumentTypes} array
   */
  @Override
  public Class<?>[] getArgumentTypes() {
    return argumentTypes.clone();
  }

  /**
   * @return The value of the {@code functionImplementationClass} attribute
   */
  @Override
  public Class getFunctionImplementationClass() {
    return functionImplementationClass;
  }

  /**
   * @return The value of the {@code isAsync} attribute
   */
  @Override
  public boolean isAsync() {
    return isAsync;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfiguredFunction#getFunctionName() functionName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for functionName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfiguredFunction withFunctionName(String value) {
    String newValue = Objects.requireNonNull(value, "functionName");
    if (this.functionName.equals(newValue)) return this;
    return new ImmutableConfiguredFunction(
        newValue,
        this.staticMethodName,
        this.returnType,
        this.argumentValueTypes,
        this.argumentMatcher,
        this.argumentTypes,
        this.functionImplementationClass,
        this.isAsync);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfiguredFunction#getStaticMethodName() staticMethodName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for staticMethodName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfiguredFunction withStaticMethodName(String value) {
    String newValue = Objects.requireNonNull(value, "staticMethodName");
    if (this.staticMethodName.equals(newValue)) return this;
    return new ImmutableConfiguredFunction(
        this.functionName,
        newValue,
        this.returnType,
        this.argumentValueTypes,
        this.argumentMatcher,
        this.argumentTypes,
        this.functionImplementationClass,
        this.isAsync);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfiguredFunction#getReturnType() returnType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for returnType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfiguredFunction withReturnType(ValueType value) {
    if (this.returnType == value) return this;
    ValueType newValue = Objects.requireNonNull(value, "returnType");
    return new ImmutableConfiguredFunction(
        this.functionName,
        this.staticMethodName,
        newValue,
        this.argumentValueTypes,
        this.argumentMatcher,
        this.argumentTypes,
        this.functionImplementationClass,
        this.isAsync);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConfiguredFunction#getArgumentValueTypes() argumentValueTypes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConfiguredFunction withArgumentValueTypes(ValueType... elements) {
    ImmutableList<ValueType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableConfiguredFunction(
        this.functionName,
        this.staticMethodName,
        this.returnType,
        newValue,
        this.argumentMatcher,
        this.argumentTypes,
        this.functionImplementationClass,
        this.isAsync);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConfiguredFunction#getArgumentValueTypes() argumentValueTypes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of argumentValueTypes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConfiguredFunction withArgumentValueTypes(Iterable<? extends ValueType> elements) {
    if (this.argumentValueTypes == elements) return this;
    ImmutableList<ValueType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableConfiguredFunction(
        this.functionName,
        this.staticMethodName,
        this.returnType,
        newValue,
        this.argumentMatcher,
        this.argumentTypes,
        this.functionImplementationClass,
        this.isAsync);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfiguredFunction#getArgumentMatcher() argumentMatcher} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for argumentMatcher
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfiguredFunction withArgumentMatcher(Predicate<ValueType[]> value) {
    if (this.argumentMatcher == value) return this;
    Predicate<ValueType[]> newValue = Objects.requireNonNull(value, "argumentMatcher");
    return new ImmutableConfiguredFunction(
        this.functionName,
        this.staticMethodName,
        this.returnType,
        this.argumentValueTypes,
        newValue,
        this.argumentTypes,
        this.functionImplementationClass,
        this.isAsync);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConfiguredFunction#getArgumentTypes() argumentTypes}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for argumentTypes
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableConfiguredFunction withArgumentTypes(Class<?>... elements) {
    Class<?>[] newValue = elements.clone();
    return new ImmutableConfiguredFunction(
        this.functionName,
        this.staticMethodName,
        this.returnType,
        this.argumentValueTypes,
        this.argumentMatcher,
        newValue,
        this.functionImplementationClass,
        this.isAsync);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfiguredFunction#getFunctionImplementationClass() functionImplementationClass} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for functionImplementationClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfiguredFunction withFunctionImplementationClass(Class value) {
    if (this.functionImplementationClass == value) return this;
    Class newValue = Objects.requireNonNull(value, "functionImplementationClass");
    return new ImmutableConfiguredFunction(
        this.functionName,
        this.staticMethodName,
        this.returnType,
        this.argumentValueTypes,
        this.argumentMatcher,
        this.argumentTypes,
        newValue,
        this.isAsync);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfiguredFunction#isAsync() isAsync} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isAsync
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfiguredFunction withIsAsync(boolean value) {
    if (this.isAsync == value) return this;
    return new ImmutableConfiguredFunction(
        this.functionName,
        this.staticMethodName,
        this.returnType,
        this.argumentValueTypes,
        this.argumentMatcher,
        this.argumentTypes,
        this.functionImplementationClass,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConfiguredFunction} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConfiguredFunction
        && equalTo((ImmutableConfiguredFunction) another);
  }

  private boolean equalTo(ImmutableConfiguredFunction another) {
    return functionName.equals(another.functionName)
        && staticMethodName.equals(another.staticMethodName)
        && returnType.equals(another.returnType)
        && argumentValueTypes.equals(another.argumentValueTypes)
        && argumentMatcher.equals(another.argumentMatcher)
        && Arrays.equals(argumentTypes, another.argumentTypes)
        && functionImplementationClass.equals(another.functionImplementationClass)
        && isAsync == another.isAsync;
  }

  /**
   * Computes a hash code from attributes: {@code functionName}, {@code staticMethodName}, {@code returnType}, {@code argumentValueTypes}, {@code argumentMatcher}, {@code argumentTypes}, {@code functionImplementationClass}, {@code isAsync}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + functionName.hashCode();
    h += (h << 5) + staticMethodName.hashCode();
    h += (h << 5) + returnType.hashCode();
    h += (h << 5) + argumentValueTypes.hashCode();
    h += (h << 5) + argumentMatcher.hashCode();
    h += (h << 5) + Arrays.hashCode(argumentTypes);
    h += (h << 5) + functionImplementationClass.hashCode();
    h += (h << 5) + Booleans.hashCode(isAsync);
    return h;
  }

  /**
   * Prints the immutable value {@code ConfiguredFunction} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ConfiguredFunction")
        .omitNullValues()
        .add("functionName", functionName)
        .add("staticMethodName", staticMethodName)
        .add("returnType", returnType)
        .add("argumentValueTypes", argumentValueTypes)
        .add("argumentMatcher", argumentMatcher)
        .add("argumentTypes", Arrays.toString(argumentTypes))
        .add("functionImplementationClass", functionImplementationClass)
        .add("isAsync", isAsync)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ConfiguredFunction} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConfiguredFunction instance
   */
  public static ImmutableConfiguredFunction copyOf(ConfiguredFunction instance) {
    if (instance instanceof ImmutableConfiguredFunction) {
      return (ImmutableConfiguredFunction) instance;
    }
    return ImmutableConfiguredFunction.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConfiguredFunction ImmutableConfiguredFunction}.
   * <pre>
   * ImmutableConfiguredFunction.builder()
   *    .functionName(String) // required {@link ConfiguredFunction#getFunctionName() functionName}
   *    .staticMethodName(String) // required {@link ConfiguredFunction#getStaticMethodName() staticMethodName}
   *    .returnType(io.dialob.rule.parser.api.ValueType) // required {@link ConfiguredFunction#getReturnType() returnType}
   *    .addArgumentValueTypes|addAllArgumentValueTypes(io.dialob.rule.parser.api.ValueType) // {@link ConfiguredFunction#getArgumentValueTypes() argumentValueTypes} elements
   *    .argumentMatcher(function.Predicate&amp;lt;io.dialob.rule.parser.api.ValueType[]&amp;gt;) // optional {@link ConfiguredFunction#getArgumentMatcher() argumentMatcher}
   *    .argumentTypes(Class&amp;lt;?&amp;gt;) // required {@link ConfiguredFunction#getArgumentTypes() argumentTypes}
   *    .functionImplementationClass(Class) // required {@link ConfiguredFunction#getFunctionImplementationClass() functionImplementationClass}
   *    .isAsync(boolean) // required {@link ConfiguredFunction#isAsync() isAsync}
   *    .build();
   * </pre>
   * @return A new ImmutableConfiguredFunction builder
   */
  public static ImmutableConfiguredFunction.Builder builder() {
    return new ImmutableConfiguredFunction.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableConfiguredFunction ImmutableConfiguredFunction}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ConfiguredFunction", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FUNCTION_NAME = 0x1L;
    private static final long INIT_BIT_STATIC_METHOD_NAME = 0x2L;
    private static final long INIT_BIT_RETURN_TYPE = 0x4L;
    private static final long INIT_BIT_ARGUMENT_TYPES = 0x8L;
    private static final long INIT_BIT_FUNCTION_IMPLEMENTATION_CLASS = 0x10L;
    private static final long INIT_BIT_IS_ASYNC = 0x20L;
    private long initBits = 0x3fL;

    private @Nullable String functionName;
    private @Nullable String staticMethodName;
    private @Nullable ValueType returnType;
    private ImmutableList.Builder<ValueType> argumentValueTypes = ImmutableList.builder();
    private @Nullable Predicate<ValueType[]> argumentMatcher;
    private @Nullable Class<?>[] argumentTypes;
    private @Nullable Class functionImplementationClass;
    private boolean isAsync;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConfiguredFunction} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ConfiguredFunction instance) {
      Objects.requireNonNull(instance, "instance");
      functionName(instance.getFunctionName());
      staticMethodName(instance.getStaticMethodName());
      returnType(instance.getReturnType());
      addAllArgumentValueTypes(instance.getArgumentValueTypes());
      argumentMatcher(instance.getArgumentMatcher());
      argumentTypes(instance.getArgumentTypes());
      functionImplementationClass(instance.getFunctionImplementationClass());
      isAsync(instance.isAsync());
      return this;
    }

    /**
     * Initializes the value for the {@link ConfiguredFunction#getFunctionName() functionName} attribute.
     * @param functionName The value for functionName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder functionName(String functionName) {
      this.functionName = Objects.requireNonNull(functionName, "functionName");
      initBits &= ~INIT_BIT_FUNCTION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ConfiguredFunction#getStaticMethodName() staticMethodName} attribute.
     * @param staticMethodName The value for staticMethodName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder staticMethodName(String staticMethodName) {
      this.staticMethodName = Objects.requireNonNull(staticMethodName, "staticMethodName");
      initBits &= ~INIT_BIT_STATIC_METHOD_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ConfiguredFunction#getReturnType() returnType} attribute.
     * @param returnType The value for returnType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder returnType(ValueType returnType) {
      this.returnType = Objects.requireNonNull(returnType, "returnType");
      initBits &= ~INIT_BIT_RETURN_TYPE;
      return this;
    }

    /**
     * Adds one element to {@link ConfiguredFunction#getArgumentValueTypes() argumentValueTypes} list.
     * @param element A argumentValueTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArgumentValueTypes(ValueType element) {
      this.argumentValueTypes.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ConfiguredFunction#getArgumentValueTypes() argumentValueTypes} list.
     * @param elements An array of argumentValueTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArgumentValueTypes(ValueType... elements) {
      this.argumentValueTypes.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ConfiguredFunction#getArgumentValueTypes() argumentValueTypes} list.
     * @param elements An iterable of argumentValueTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder argumentValueTypes(Iterable<? extends ValueType> elements) {
      this.argumentValueTypes = ImmutableList.builder();
      return addAllArgumentValueTypes(elements);
    }

    /**
     * Adds elements to {@link ConfiguredFunction#getArgumentValueTypes() argumentValueTypes} list.
     * @param elements An iterable of argumentValueTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllArgumentValueTypes(Iterable<? extends ValueType> elements) {
      this.argumentValueTypes.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link ConfiguredFunction#getArgumentMatcher() argumentMatcher} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ConfiguredFunction#getArgumentMatcher() argumentMatcher}.</em>
     * @param argumentMatcher The value for argumentMatcher 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder argumentMatcher(Predicate<ValueType[]> argumentMatcher) {
      this.argumentMatcher = Objects.requireNonNull(argumentMatcher, "argumentMatcher");
      return this;
    }

    /**
     * Initializes the value for the {@link ConfiguredFunction#getArgumentTypes() argumentTypes} attribute.
     * @param argumentTypes The elements for argumentTypes
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder argumentTypes(Class<?>... argumentTypes) {
      this.argumentTypes = argumentTypes.clone();
      initBits &= ~INIT_BIT_ARGUMENT_TYPES;
      return this;
    }

    /**
     * Initializes the value for the {@link ConfiguredFunction#getFunctionImplementationClass() functionImplementationClass} attribute.
     * @param functionImplementationClass The value for functionImplementationClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder functionImplementationClass(Class functionImplementationClass) {
      this.functionImplementationClass = Objects.requireNonNull(functionImplementationClass, "functionImplementationClass");
      initBits &= ~INIT_BIT_FUNCTION_IMPLEMENTATION_CLASS;
      return this;
    }

    /**
     * Initializes the value for the {@link ConfiguredFunction#isAsync() isAsync} attribute.
     * @param isAsync The value for isAsync 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isAsync(boolean isAsync) {
      this.isAsync = isAsync;
      initBits &= ~INIT_BIT_IS_ASYNC;
      return this;
    }

    /**
     * Builds a new {@link ImmutableConfiguredFunction ImmutableConfiguredFunction}.
     * @return An immutable instance of ConfiguredFunction
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConfiguredFunction build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableConfiguredFunction(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FUNCTION_NAME) != 0) attributes.add("functionName");
      if ((initBits & INIT_BIT_STATIC_METHOD_NAME) != 0) attributes.add("staticMethodName");
      if ((initBits & INIT_BIT_RETURN_TYPE) != 0) attributes.add("returnType");
      if ((initBits & INIT_BIT_ARGUMENT_TYPES) != 0) attributes.add("argumentTypes");
      if ((initBits & INIT_BIT_FUNCTION_IMPLEMENTATION_CLASS) != 0) attributes.add("functionImplementationClass");
      if ((initBits & INIT_BIT_IS_ASYNC) != 0) attributes.add("isAsync");
      return "Cannot build ConfiguredFunction, some of required attributes are not set " + attributes;
    }
  }
}
